%define dist Devel-GlobalDestruction
Name: perl-%dist
Version: 0.09
Release: alt1

Summary: Expose the flag which marks global destruction
License: GPL or Artistic
Group: Development/Perl

URL: %CPAN %dist
Source: %dist-%version.tar.gz

BuildArch: noarch

# New global variable ${^GLOBAL_PHASE}
Requires: perl-base >= 1:5.14
BuildRequires: perl-base >= 1:5.14

# Automatically added by buildreq on Sun Oct 09 2011
BuildRequires: perl-Sub-Exporter perl-devel perl-Sub-Exporter-Progressive

%description
Perl's global destruction is a little tricky to deal with WRT finalizers
because it's not ordered and objects can sometimes disappear.

Writing defensive destructors is hard and annoying, and usually if global
destruction is happenning you only need the destructors that free up non
process local resources to actually execute.

For these constructors you can avoid the mess by simply bailing out if global
destruction is in effect.

%prep
%setup -q -n %dist-%version
%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes
%perl_vendor_privlib/Devel

%changelog
