# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Exporter.pm) perl(Test/More.pm) perl-devel perl-podlators
# END SourceDeps(oneline)
%define upstream_name    Iterator-Util
%define upstream_version 0.02

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_1

Summary:    Essential utilities for the Iterator class
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        http://search.cpan.org/dist/%{upstream_name}
Source0:    http://www.cpan.org/modules/by-module/Iterator/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Exception/Class.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(Iterator.pm)
BuildRequires: perl(Test/Simple.pm)
BuildArch: noarch
Source44: import.info

%description
This module implements many useful functions for creating and manipulating
iterator objects.

An "iterator" is an object, represented as a code block that generates the
"next value" of a sequence, and generally implemented as a closure. For
further information, including a tutorial on using iterator objects, see
the the Iterator manpage documentation.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
%{__perl} Makefile.PL INSTALLMAN1DIR=%_man1dir INSTALLMAN1DIR=%_man1dir INSTALLDIRS=vendor

%make

%check
%make test

%install
%makeinstall_std

%files
%doc Changes META.yml README
%perl_vendor_privlib/*




%changelog
