#
#   - Net::Amazon -
#   This spec file was automatically generated by cpan2rpm [ver: 2.027]
#   (ALT Linux revision)
#   The following arguments were used:
#       Net::Amazon
#   For more information on cpan2rpm please visit: http://perl.arix.com/
#

%define module Net-Amazon
%define m_distro Net-Amazon
%define m_name Net::Amazon
%define m_author_id unknown
%define _enable_test 1

Name: perl-Net-Amazon
Version: 0.61
Release: alt1

Summary: Framework for accessing amazon.com via REST

License: Artistic
Group: Development/Perl
Url: http://www.cpan.org

Packager: Denis Smirnov <mithraen@altlinux.ru>

BuildArch: noarch
Source: http://www.cpan.org/authors/id/B/BO/BOUMENOT/Net-Amazon-%{version}.tar.gz

# Automatically added by buildreq on Sat Sep 04 2010
BuildRequires: perl-Digest-SHA perl-Log-Log4perl perl-XML-Parser perl-XML-Simple perl-devel

%description
"Net::Amazon" works very much like "LWP": First you define a useragent
like

  my $ua = Net::Amazon->new(
      token      => 'YOUR_AMZN_TOKEN',
      secret_key => 'YOUR_AMZN_SECRET_KEY',
      max_pages => 3,
  );

which you pass your personal amazon developer's token (can be obtained
from <http://amazon.com/soap>) and (optionally) the maximum number of
result pages the agent is going to request from Amazon in case all
results don't fit on a single page (typically holding 20 items).  Note that
each new page requires a minimum delay of 1 second to comply with Amazon's
one-query-per-second policy.

According to the different search methods on Amazon, there's a bunch
of different request types in "Net::Amazon". The user agent's
convenience method "search()" triggers different request objects,
depending on which parameters you pass to it:

=over 4

=item "$ua->search(asin => "0201360683")"

The "asin" parameter has Net::Amazon search for an item with the
specified ASIN. If the specified value is an arrayref instead of a single
scalar, like in

    $ua->search(asin => ["0201360683", "0596005083"])

then a search for multiple ASINs is performed, returning a list of
results.

=item "$ua->search(actor => "Adam Sandler")"

The "actor" parameter has the user agent search for items created by
the specified actor. Can return many results.

=item "$ua->search(artist => "Rolling Stones")"

The "artist" parameter has the user agent search for items created by
the specified artist. Can return many results.

=item "$ua->search(author => "Robert Jordan")"

The "author" parameter has the user agent search for items created by
the specified author. Can return many results.

=item "$ua->search(browsenode=>"4025", mode=>"books" [, keywords=>"perl"])"

Returns a list of items by category ID (node). For example node "4025"
is the CGI books category.  You can add a keywords parameter to filter
the results by that keyword.

=item "$ua->search(exchange => 'Y04Y3424291Y2398445')"

Returns an item offered by a third-party seller. The item is referenced
by the so-called *exchange ID*.

=item "$ua->search(keyword => "perl xml", mode => "books")"

Search by keyword, mandatory parameters "keyword" and "mode".
Can return many results.

=item "$ua->search(wishlist => "1XL5DWOUFMFVJ")"

Search for all items in a specified wishlist.
Can return many results.

=item "$ua->search(upc => "075596278324", mode => "music")"

Music search by UPC (product barcode), mandatory parameter "upc".
"mode" has to be set to "music". Returns at most one result.

=item "$ua->search(isbn => "0439784549")"

Book search by ISBN (International Standard Book Number), mandatory parameter
"isbn".  Returns at most one result.  When searching non-US locales use the
13-digit ISBN.

=item "$ua->search(similar => "0201360683")"

Search for all items similar to the one represented by the ASIN provided.
Can return many results.

=item "$ua->search(power => "subject: perl and author: schwartz", mode => "books")"

Initiate a power search for all books matching the power query.
Can return many results. See Net::Amazon::Request::Power for details.

=item "$ua->search(manufacturer => "Disney")"

Initiate a search for all items made by a given manufacturrer.
Can return many results. See Net::Amazon::Request::Manufacturer
for details.

=item "$ua->search(musiclabel => "Arista")"

Initiate a search for all items made by a given music label. Can return many
results. See Net::Amazon::Request::MusicLabel for details.

=item "$ua->search(publisher => "o'reilly")"

Initiate a search for all items made by a given publisher. Can return many
results. See Net::Amazon::Request::Publisher for details.

=item "$ua->search(blended => "Perl")"

Initiate a search for items in all categories.

=item "$ua->search(seller => "A2GXAGU54VOP7")"

Start a search on items sold by a specific third-party seller, referenced
by its ID (not seller name).

=item "$ua->search(textstream => "Blah blah Rolling Stones blah blah")"

Find items related to keywords within a text stream.

=back

The user agent's "search" method returns a response object, which can be
checked for success or failure:

  if($resp->is_success()) {
      print $resp->as_string();
  } else {
      print "Error: ", $resp->message(), "\n";
  }

In case the request for an item search
succeeds, the response contains one or more
Amazon 'properties', as it calls the products found.
All matches can be retrieved from the Response
object using it's "properties()" method.

In case the request fails, the response contains one or more
error messages. The response object's "message()" method will
return it (or them) as a single string, while "messages()" (notice
the plural) will
return a reference to an array of message strings.

Response objects always have the methods
"is_success()",
"is_error()",
"message()",
"total_results()",
"as_string()" and
"properties()" available.

"total_results()" returns the total number of results the search
yielded.
"properties()" returns one or more "Net::Amazon::Property" objects of type
"Net::Amazon::Property" (or one of its subclasses like
"Net::Amazon::Property::Book", "Net::Amazon::Property::Music"
or Net::Amazon::Property::DVD), each
of which features accessors named after the attributes of the product found
in Amazon's database:

    for ($resp->properties) {
       print $_->Asin(), " ",
             $_->OurPrice(), "\n";
    }

In scalar context, "properties()" just returns the *first*
"Net::Amazon::Property" object found.
Commonly available accessors to "Net::Amazon::Property" objects are
"OurPrice()",
"ImageUrlLarge()",
"ImageUrlMedium()",
"ImageUrlSmall()",
"ReleaseDate()",
"Catalog()",
"Asin()",
"url()",
"Manufacturer()",
"UsedPrice()",
"ListPrice()",
"ProductName()",
"Availability()",
"SalesRank()",
"CollectiblePrice()",
"CollectibleCount()",
"NumberOfOfferings()",
"UsedCount()",
"ThirdPartyNewPrice()",
"ThirdPartyNewCount()",
"similar_asins()".
For details, check Net::Amazon::Property.

Also, the specialized classes "Net::Amazon::Property::Book" and
"Net::Amazon::Property::Music" feature convenience methods like
"authors()" (returning the list of authors of a book) or
"album()" for CDs, returning the album title.

Customer reviews:
Every property features a "review_set()" method which returns a
"Net::Amazon::Attribute::ReviewSet" object, which in turn offers
a list of "Net::Amazon::Attribute::Review" objects. Check the respective
man pages for details on what's available.

%prep
%setup -q -n %m_distro-%version
%build
%perl_vendor_build

%install
%perl_vendor_install
rm -rf %buildroot%perl_vendor_man3dir/

%files
%perl_vendor_privlib/Net/*

%changelog
