%define dist SDL_Perl
Name: perl-SDL
Version: 2.2.6
Release: alt3

Summary: Simple DirectMedia Layer for Perl
License: LGPL
Group: Development/Perl

URL: %CPAN %dist
Source: %dist-v%version.tar.gz

# avoid crazy dependencies
%add_findreq_skiplist */SDL/Tutorial*

# Automatically added by buildreq on Fri Oct 07 2011
BuildRequires: libSDL_gfx-devel libSDL_image-devel libSDL_mixer-devel libSDL_net-devel libSDL_ttf-devel libjpeg-devel libpng-devel libsmpeg-devel perl-Module-Build

%package OpenGL
Summary: Simple DirectMedia Layer for Perl (OpenGL)
Group: Development/Perl
Requires: %name = %version-%release

%description
SDL_Perl is a wrapper around the cross platform Simple DirectMedia Layer
game library. Essentially it allows to write cross platform games in Perl,
using 2d (SDL), or 3d (OpenGL), or a combination of both if you wish.

%description OpenGL
SDL_Perl is a wrapper around the cross platform Simple DirectMedia Layer
game library. Essentially it allows to write cross platform games in Perl,
using 2d (SDL), or 3d (OpenGL), or a combination of both if you wish.

%prep
%setup -q -n %dist-v%version

# avoid build dependency on YAML
sed -i- '/^use YAML/d' Build.PL

%ifdef __BTE
# mixer is not available in restricted environment
mv t/mixerpm.t t/mixerpm.t.orig
%endif

%build
%perl_vendor_build

%install
%perl_vendor_install

# Check that our Module::Build links perl extensions with -lperl.
objdump -p %buildroot%perl_vendor_autolib/SDL_perl/SDL_perl.so |egrep 'NEEDED[[:space:]]+libperl'

%files
%doc BUGS CHANGELOG README TODO
%perl_vendor_archlib/SDL*
%perl_vendor_autolib/SDL*
%exclude %perl_vendor_archlib/SDL/OpenGL*
%exclude %perl_vendor_autolib/SDL/OpenGL*

%files OpenGL
%perl_vendor_archlib/SDL/OpenGL*
%perl_vendor_autolib/SDL/OpenGL*

%changelog
