%define dist Tk
Name: perl-%dist
Version: 804.030
Release: alt1

Summary: Perl modules providing the Tk graphics library
License: GPL/Artistic/Tk/Tix
Group: Development/Perl

URL: %CPAN %dist
Source: %dist-%version.tar
Patch: %name-%version-%release.patch

# fix for deparse failure
%define __spec_autodep_custom_pre export PERL5OPT='-I%buildroot%perl_vendor_archlib -MTk'

# provides for demos are useless
%add_findprov_skiplist %perl_vendor_archlib/Tk/demos/*/*.pl

# demos/widget_lib is a separate library tree
%define _perl_lib_path %perl_vendor_archlib/Tk/demos/widget_lib

Provides: perl-Tk-JPEG
Obsoletes: perl-Tk-JPEG

# Automatically added by buildreq on Sat Oct 08 2011
BuildRequires: fonts-ttf-dejavu fonts-type1-urw imake libXcursor libXft-devel libjpeg-devel libpng-devel perl-Devel-Leak perl-Encode perl-devel xprop xvfb-run

%description
This is a set of Perl modules which provide access to the Tk library,
a Graphical User Interface ToolKit.

%package devel
Summary: Perl modules providing the Tk graphics library
Group: Development/Perl
Requires: %name = %version-%release

%description devel
This is a set of Perl modules which provide access to the Tk library,
a Graphical User Interface ToolKit.

%package demos
Summary: Perl modules providing the Tk graphics library
Group: Development/Perl
Requires: %name = %version-%release

%description demos
This is a set of Perl modules which provide access to the Tk library,
a Graphical User Interface ToolKit.

%prep
%setup -q -n %dist-%version
%patch -p1
rm -r PNG/zlib/ PNG/libpng/

# font-dependent tests, see README
rm t/entry.t t/listbox.t

%ifdef __buildreqs
rm t/dirtree.t
%endif

# XXX fails under Xvfb in hasher
rm t/fileevent2.t

cd pTk
for f in license.*; do
mv "$f" "Tk.$f"
done
cd -

%build
%ifndef _build_display
%def_without test
%endif

%def_with xft
%perl_vendor_build %{?_with_xft:XFT=1} X11LIB=%_x11libdir
xvfb-run -a make test

%install
%perl_vendor_install

%files
%doc COPYING README README.linux Funcs.doc ToDo pTk/*license*
	%_bindir/ptked
	%_bindir/ptksh
	%_bindir/tkjpeg
	%perl_vendor_archlib/Tie*
	%perl_vendor_archlib/Tk*
	%perl_vendor_autolib/Tk*
%exclude %perl_vendor_archlib/Tk/demos
%exclude %perl_vendor_archlib/Tk/pTk*
%exclude %perl_vendor_archlib/Tk/*.def
%exclude %perl_vendor_archlib/Tk/*.[hmt]
%exclude %perl_vendor_archlib/Tk/typemap
%exclude %perl_vendor_archlib/Tk/MakeDepend.pm
%exclude %perl_vendor_archlib/Tk/MMutil.pm

%files devel
%dir	%perl_vendor_archlib/Tk
	%perl_vendor_archlib/Tk/pTk*
	%perl_vendor_archlib/Tk/*.def
	%perl_vendor_archlib/Tk/*.[hmt]
	%perl_vendor_archlib/Tk/typemap
	%perl_vendor_archlib/Tk/MakeDepend.pm
	%perl_vendor_archlib/Tk/MMutil.pm

%files demos
%doc	demos/README
	%_bindir/gedi
	%_bindir/widget
%dir	%perl_vendor_archlib/Tk
%dir	%perl_vendor_archlib/Tk/demos
	%perl_vendor_archlib/Tk/demos/*.pm
	%perl_vendor_archlib/Tk/demos/images/
	%perl_vendor_archlib/Tk/demos/widget_lib/
	%perl_vendor_archlib/Tk/demos/widtrib/

%changelog
