%define php5_sapi cgi

Name: php5-cgi
Version: %php5_version
Release: %php5_release
Summary: The PHP5 HTML-embedded scripting language as a CGI binary.
Group: System/Servers
Url: http://www.php.net/
License: PHP

Requires: php5 = %php5_version
Requires: php5 >= %php5_version-%php5_release
Provides: php-engine = %php5_version-%php5_release

Source1: php.ini
Source2: %name-browscap.ini

Patch0:	 php-5.3.3-config9.m4.patch
Patch1:	 php-5.3-sapi-name-cgi.patch

BuildRequires(pre): rpm-build-php5
BuildRequires:	php5-devel = %php5_version

# Automatically added by buildreq on Tue Jul 05 2005 (-bi)
BuildRequires: libalternatives-devel libxml2-devel zlib-devel

%description
PHP is an HTML-embedded scripting language.  PHP attempts to make it
easy for developers to write dynamically generated web pages.  PHP
also offers built-in database integration for several commercial
and non-commercial database management systems, so writing a
database-enabled web page with PHP is fairly simple.  The most
common use of PHP coding is probably as a replacement for CGI
scripts.  
Using PHP as a CGI binary is an option for setups that for some reason 
do not wish to integrate PHP as a module into server software (like Apache), 
or will use PHP with different kinds of CGI wrappers to create safe 
chroot and setuid environments for scripts. 
This setup usually involves installing executable PHP binary to the 
web server cgi-bin directory. CERT advisory CA-96.11 recommends 
against placing any interpreters into cgi-bin.

%prep
%setup -T -c
%php5_sapi_prepare %php5_sapi
ln -s %php5_extsrcdir ext

%patch0 -p1 -b .fix
%patch1 -p1 -b .fix1

%build
%add_optflags -DPHP_FASTCGI -DDEBUG_FASTCGI -I/usr/include/libxml2 -Iext/date/lib

# fix simple bug.
mv config9.m4 config.m4

# some hackaround
mkdir -p sapi modules
ln -s ../ sapi/%php5_sapi
echo -n > modules/z

CGI_BUILD_VARS=" \
    PHP_SAPI=none \
    PHP_MODULES=sapi/%php5_sapi/php-cgi \
    EXTRA_LIBS=-lphp-%_php5_version \
    BUILD_DIR=. \
"

phpize 
%configure \
	--disable-static \
	--enable-cgi \
	--enable-fastcgi \
	--enable-force-cgi-redirect \
	--with-php-config=%_bindir/php-config \
	$CGI_BUILD_VARS 

%php5_make 
cp php-cgi.1.in php-cgi.1

%install
mkdir -p \
	%buildroot/%_bindir \
	%buildroot/%php5_servicedir/%php5_sapi \
	%buildroot/%php5_sysconfdir/%php5_sapi/php.d
	
%php5_make_install install-%php5_sapi program_suffix=-%_php5_version

ln -s php-%php5_sapi-%_php5_version %buildroot%_bindir/php5-%php5_sapi

install -m 644 %SOURCE1 %buildroot/%php5_sysconfdir/%php5_sapi/php.ini
install -m 644 %SOURCE2 %buildroot/%php5_sysconfdir/%php5_sapi/browscap.ini

for f in \
	%buildroot/%php5_sysconfdir/%php5_sapi/php.ini
do
  subst 's,@SAPI@,%php5_sapi,g' "$f"
  subst 's,@PHP_VERSION@,%_php5_version,g' "$f"
  subst 's,@PHP_MAJOR@,%_php5_major,g' "$f"
  subst 's,@PHP_LIBDIR@,%_libdir/php,g' "$f"
  subst 's,@CGIBINDIR@,%webserver_cgibindir,g' "$f"
  subst 's,@PHP_BROWSCAP@,%php5_sysconfdir/%php5_sapi/browscap.ini,g' "$f"
done

# Make alternatives support.
install -d %buildroot/%_altdir
php_weight="$(echo "%_php5_version" | sed 's,[^[:digit:]],,g')"

cat << EOF > %buildroot/%_altdir/php5-%php5_sapi
%_bindir/php-%php5_sapi	%_bindir/php-%php5_sapi-%_php5_version	$php_weight
EOF
rm -rf %buildroot%_mandir/*/*

%post
%php5_sapi_postin

%preun
%php5_sapi_preun

%files
%doc CREDITS README.FastCGI
%_bindir/php-%php5_sapi-%_php5_version
%_bindir/php5-%php5_sapi
%_altdir/php5-%php5_sapi 
%dir %php5_sysconfdir/%php5_sapi
%dir %php5_sysconfdir/%php5_sapi/php.d
%config(noreplace) %php5_sysconfdir/%php5_sapi/php.ini
%config(noreplace) %php5_sysconfdir/%php5_sapi/browscap.ini
%php5_servicedir/%php5_sapi

%changelog
