%define		php5_extension	dba

Name:	 	php5-%php5_extension
Version:	%php5_version
Release:	%php5_release

Summary:	DBA (gdbm, db4) module for PHP5
Group:		System/Servers
License:	PHP Licence

Source1:	php-%php5_extension.ini
Source2:	php-%php5_extension-params.sh

BuildRequires(pre): rpm-build-php5
BuildRequires:	php5-devel = %php5_version

# Automatically added by buildreq on Fri Jul 01 2005
BuildRequires: libdb4-devel libgdbm-devel

%description
The %name includes a dynamic shared object (DSO) that adds 
gdbm and db4 support to PHP.

These functions build the foundation for accessing Berkeley DB style
databases. This is a general abstraction layer for several file-based
databases. As such, functionality is limited to a subset of features
modern databases such as Sleepycat Software DB4 support. The behaviour 
of various aspects depend on the implementation of the underlying 
database. Functions such as dba_optimize() and dba_sync() will do 
what they promise for one database and will do nothing for others.

%prep
%setup -T -c
cp -pr %php5_extsrcdir/%php5_extension/* .

%build
phpize

BUILD_HAVE=`echo %php5_extension | tr '[:lower:]-' '[:upper:]_'`
%add_optflags -fPIC -L%_libdir 
export LDFLAGS=-lphp-%_php5_version
%configure \
%ifarch x86_64
	--with-libdir=%_lib \
%endif
	--with-gdbm \
	--with-db4=%_usr \
	--enable-%php5_extension
%php5_make

%install
%php5_make_install
install -D -m 644 %SOURCE1 %buildroot/%php5_extconf/%php5_extension/config
install -D -m 644 %SOURCE2 %buildroot/%php5_extconf/%php5_extension/params

%files
%php5_extconf/%php5_extension
%php5_extdir/*
%doc CREDITS

%post
%php5_extension_postin

%preun
%php5_extension_preun

%changelog
