%define	php5_extension	gd
%define	gd_ver	2

Name:	 	php5-%php5_extension%gd_ver
Version:	%php5_version
Release:	%php5_release

Summary:	GD library support for PHP5
Group:		System/Servers
License:	PHP Licence

Source1:	php-%php5_extension%gd_ver.ini
Source2:	php-%php5_extension%gd_ver-params.sh

BuildRequires(pre): rpm-build-php5
# Automatically added by buildreq on Thu Jan 28 2010
BuildRequires: glibc-devel-static libfreetype-devel libjpeg-devel libpng-devel php5-devel t1lib-devel

BuildRequires:	php5-devel = %php5_version

%description
The %name includes a dynamic shared object (DSO) that adds
GD support to PHP. GD is a library that enables you to create PNG,
JPEG, XPM, and WBMP graphics. It is linked with freetype and t1lib so
you can use TrueType fonts. PHP is an HTML-embedded scripting language.
If you need GD support for PHP applications, you will need to install
this package in addition to the php package.

%prep
%setup -T -c
cp -pr %php5_extsrcdir/%php5_extension/* .

%build
phpize

BUILD_HAVE=`echo %php5_extension | tr '[:lower:]-' '[:upper:]_'`
%add_optflags -fPIC -L%_libdir
export LDFLAGS=-lphp-%_php5_version
%configure \
	--enable-gd-native-ttf \
	--without-xpm \
	--with-jpeg-dir=%_prefix \
	--with-t1lib \
	--with-ttf=%_prefix \
	--with-png-dir=%_prefix \
	--with-zlib-dir=%_prefix \
	--with-freetype-dir=%_prefix \
	--with-libdir=%_lib \
	--enable-exif \
	--with-%php5_extension
%php5_make

%install
%php5_make_install
install -D -m 644 %SOURCE1 %buildroot/%php5_extconf/%php5_extension/config
install -D -m 644 %SOURCE2 %buildroot/%php5_extconf/%php5_extension/params

%files
%php5_extconf/%php5_extension
%php5_extdir/*
%doc CREDITS

%post
%php5_extension_postin

%preun
%php5_extension_preun

%changelog
