%define		php5_extension	magickwand
%define 	real_name	MagickWandForPHP
%define		real_version	1.0.9-2

Name:	 	php5-%{php5_extension}
Version:	%php5_version
Release:	%php5_release.1

Summary:	PHP5 extension to access the ImageMagick MagickWand API

License:	OpenSource
Group:		System/Servers
URL:		http://www.magickwand.org/

Packager:	Nikolay A. Fetisov <naf@altlinux.ru>

Source0:	%real_name-%real_version.tar
Source1:	php-%php5_extension.ini
Source2:	php-%php5_extension-params.sh

BuildRequires(pre): rpm-build-php5

BuildRequires: php5-devel = %php5_version
BuildRequires: libImageMagick-devel

%description
MagickWand for PHP is a native PHP interface to the new ImageMagick
MagickWand API.

It is an almost complete port of the ImageMagick C API, excluding some
X-Server related functionality, and progress monitoring.

The functionality of the MagickWand API is pretty much unparalelled in
the PHP imaging world, allowing the PHP programmer read/write/manipulate
access to multiple image formats, along with vector drawing, pixel-level
manipulation, and special effects capabilities and more.

%prep
%setup -T -c
tar xvf %SOURCE0

%build
phpize

BUILD_HAVE=`echo %php5_extension | tr '[:lower:]-' '[:upper:]_'`
%add_optflags -fPIC -L%_libdir
export LDFLAGS=-lphp-%_php5_version
%configure \
	--with-%php5_extension \
	--with-libdir=%_lib \
	#

%php5_make

%install
%php5_make_install
install -D -m 644 -- %SOURCE1 %buildroot/%php5_extconf/%php5_extension/config
install -D -m 644 -- %SOURCE2 %buildroot/%php5_extconf/%php5_extension/params

%files
%doc CREDITS README AUTHOR LICENSE

%php5_extconf/%php5_extension
%php5_extdir/*

%post
%php5_extension_postin

%preun
%php5_extension_preun

%changelog
