%define		php5_extension	pdo_odbc

Name:	 	php5-%php5_extension
Version:	%php5_version
Release:	%php5_release

Summary:	ODBC driver for PHP5 Data Objects Interface

Group:		System/Servers
License:	PHP Licence
URL:		http://www.php.net/manual/en/ref.pdo-odbc.php
#		http://pecl.php.net/package/PDO_ODBC

Packager:	Nikolay A. Fetisov <naf@altlinux.ru>

#Source0:	standart PHP module
Source1:	php-%php5_extension.ini
Source2:	php-%php5_extension-params.sh

BuildRequires(pre): rpm-build-php5
BuildRequires: gcc-c++ libunixODBC-devel
BuildRequires: php5-devel = %php5_version

Requires: php5-pdo = %php5_version-%php5_release
Provides: php5-pdo-driver

%description
PHP5 PDO extension provides a uniform data access interface, supporting advanced
features such as prepared statements and bound parameters. 
This package contains a ODBC driver for PDO.

%prep
%setup -T -c
cp -pr -- %php5_extsrcdir/%php5_extension/* .

# Fix path to pdo*.h
subst 's@php/ext@php/%_php5_version/ext@g' config.m4

%build
phpize

BUILD_HAVE=`echo %php5_extension | tr '[:lower:]-' '[:upper:]_'`
%add_optflags -fPIC -L%_libdir
export LDFLAGS=-lphp-%_php5_version

# Fix for config.m4 in %%prep would't work for some reason
%__subst 's@php/ext@php/%_php5_version/ext@g' configure

# Fix PHP bug #48913 (buffer overflow due too long error code string)
%__subst 's#IM0001#IM001#g' odbc_stmt.c

%configure \
	--with-%php5_extension \
	--with-libdir=%_lib \
	--with-pdo-odbc=unixODBC,%_usr \
	#

%php5_make

%install
%php5_make_install
install -D -m 644 -- %SOURCE1 %buildroot/%php5_extconf/%php5_extension/config
install -D -m 644 -- %SOURCE2 %buildroot/%php5_extconf/%php5_extension/params

%files
%php5_extconf/%php5_extension
%php5_extdir/*
%doc CREDITS

%post
%php5_extension_postin

%preun
%php5_extension_preun

%changelog
