%define php5_extension	xdebug

Name: php5-%php5_extension
Version: %php5_version
Release: %php5_release

Summary: xdebug extensions
Group: System/Servers
License: PHP Licence

Packager: Denis Klimov <zver@altlinux.ru>

Source: php5-%php5_extension.tar
Source1: php-%php5_extension.ini
Source2: php-%php5_extension-params.sh

BuildRequires(pre): rpm-build-php5
BuildRequires: php5-devel = %php5_version

%description
The Xdebug extension helps you debugging your script by providing
a lot of valuable debug information. The debug information that
Xdebug can provide includes the following:
    * stack traces and function traces in error messages with:
          o full parameter display for user defined functions
          o function name, file name and line indications
          o support for member functions
    * memory allocation
    * protection for infinite recursions

Xdebug also provides:
    * profiling information for PHP scripts
    * code coverage analysis
    * capabilities to debug your scripts interactively with a debug client

%prep
%setup -n php5-%php5_extension
%build
phpize

BUILD_HAVE=`echo %php5_extension | tr '[:lower:]-' '[:upper:]_'`
%add_optflags -fPIC -L%_libdir
export LDFLAGS=-lphp-%_php5_version
%configure \
	--with-%php5_extension=%_usr
%php5_make

%install
install -D -m 644 modules/xdebug.so %buildroot%php5_extdir/xdebug.so
install -D -m 644 %SOURCE1 %buildroot%php5_extconf/%php5_extension/config
install -D -m 644 %SOURCE2 %buildroot%php5_extconf/%php5_extension/params
echo "zend_extension=%php5_extdir/xdebug.so" >%buildroot%php5_extconf/%php5_extension/config

%files
%php5_extconf/%php5_extension
%php5_extdir/xdebug.so

%post
%php5_extension_postin

%preun
%php5_extension_preun

%changelog
