%add_findreq_skiplist %perl_vendor_archlib/*

%def_enable nss
%def_enable gtkspell

%def_disable devel

%def_disable perl
%def_disable tcl
%def_disable tk
%def_disable cyrus_sasl
%def_disable gnutls
%def_disable gevolution
%def_disable meanwhile
%def_disable cap
%def_disable nm
%def_disable mono
%def_disable consoleui
%def_disable dbus
%def_disable avahi
%def_disable dot
%def_disable doxygen
%def_disable relnot
%def_disable idn
%def_disable farsight
%def_disable gstreamer
%def_disable screensaver
%def_disable startup_notification
%def_disable gestures
%def_disable devhelp
%def_disable sm
%def_disable vv

%define oname pidgin

Name: pidgin-mini
Version: 2.10.0
Release: alt1

Summary: A GTK+ based multiprotocol instant messaging client
License: GPL
Group: Networking/Instant messaging
Url: http://pidgin.im
Packager: Slava Semushin <php-coder@altlinux.ru>

Provides: gaim = %version
Obsoletes: gaim
Conflicts: %oname

Requires: libpurple-mini = %version-%release
Requires(post,postun): desktop-file-utils
PreReq: GConf

Source0: %oname-%version.tar.bz2
Source1: %oname-be.po.bz2
Source3: %oname-ru.po.bz2
Source2: purple-altlinux-prefs.xml
Patch0: pidgin-2.6.1-reread-resolvconf.patch
Patch1: pidgin-NOT-UPSTREAM-2.5.4-icq-russia.patch
Patch2: pidgin-2.6.1-alt-confdir.patch
Patch3: pidgin-alt-configure.patch
Patch4: pidgin-alt-oscar-def_enc-CP1251.patch
Patch6: pidgin-alt-doc-man_fix.patch
Patch7: pidgin-mini-alt-soname.patch


# From configure.ac
BuildPreReq: glib2-devel >= 2.12.0
BuildPreReq: libgtk+2-devel >= 2.10.0
BuildPreReq: libpango-devel >= 1.4.0
BuildPreReq: libXext-devel libX11-devel
%{?_enable_gtkspell:BuildPreReq: libgtkspell-devel >= 2.0.2}
%{?_enable_nss:BuildPreReq: libnss-devel libnspr-devel}
%{?_enable_cyrus_sasl:BuildPreReq: libsasl2-devel}
%{?_enable_gnutls:BuildPreReq: libgnutls-devel}
%{?_enable_consoleui:BuildPreReq: libncurses-devel libncursesw-devel}
%{?_enable_nm:BuildPreReq: NetworkManager-devel}
%{?_enable_meanwhile:BuildPreReq: libmeanwhile-devel}
%{?_enable_perl:BuildPreReq: perl-devel}
%{?_enable_tcl:BuildPreReq: tcl-devel}
%{?_enable_tk:BuildPreReq: tk-devel}
%{?_enable_mono:BuildRequires: mono-devel mono-mcs rpm-build-mono mono-nunit-devel /proc}
%{?_enable_gevolution:BuildPreReq: evolution-data-server-devel}
%{?_enable_dbus:BuildPreReq: libdbus-devel >= 0.35 libdbus-glib-devel >= 0.35}
%{?_enable_avahi:BuildPreReq: libavahi-devel libavahi-glib-devel}
%{?_enable_dot:BuildPreReq: graphviz}
%{?_enable_doxygen:BuildPreReq: doxygen}
%{?_enable_idn:BuildPreReq: libidn-devel}
%{?_enable_farsight:BuildPreReq: farsight2-devel}
%{?_enable_vv:BuildPreReq: gst-plugins-devel}
%{?_enable_gstreamer:BuildPreReq: gstreamer-devel}
%{?_enable_sm:BuildPreReq: libSM-devel}
%{?_enable_screensaver:BuildPreReq: libXScrnSaver-devel xorg-scrnsaverproto-devel}
%{?_enable_startup_notification:BuildPreReq: libstartup-notification-devel >= 0.5}
BuildPreReq: libsqlite3-devel >= 3.3
BuildPreReq: libxml2-devel >= 2.6.0
BuildPreReq: GConf libGConf-devel

BuildRequires: gcc-c++ libgpg-error
BuildRequires: python-modules-encodings
# for shared gadu plugin
BuildRequires: libgadu-devel >= 1.9.0
BuildRequires: intltool
# now intltool wants that
BuildRequires: perl-XML-Parser

BuildPreReq: desktop-file-utils
BuildPreReq: ca-certificates

%description
Pidgin allows you to talk to anyone using a variety of messaging
protocols including AIM, MSN, Yahoo!, Jabber, Bonjour, Gadu-Gadu,
ICQ, IRC, Novell Groupwise, QQ, Lotus Sametime, SILC, Simple and
Zephyr.  These protocols are implemented using a modular, easy to
use design.  To use a protocol, just add an account using the
account editor.

Pidgin supports many common features of other clients, as well as many
unique features, such as perl scripting, TCL scripting and C plugins.

Pidgin is not affiliated with or endorsed by America Online, Inc.,
Microsoft Corporation, Yahoo! Inc., or ICQ Inc.

%package devel
Summary: Development headers, documentation, and libraries for Pidgin
Group: Development/Other
Requires: %name = %version-%release
Requires: libpurple-mini-devel = %version-%release
Provides: gaim-devel = %version
Obsoletes: gaim-devel
Conflicts: pidgin-devel

%description devel
The pidgin-devel package contains the header files, developer
documentation, and libraries required for development of Pidgin scripts
and plugins.

%package -n libpurple-mini
Summary: libpurple library for IM clients like Pidgin and Finch
Group: Networking/Instant messaging
Requires: ca-certificates
Conflicts: libpurple

%description -n libpurple-mini
libpurple contains the core IM support for IM clients such as Pidgin
and Finch.

libpurple supports a variety of messaging protocols including AIM, MSN,
Yahoo!, Jabber, Bonjour, Gadu-Gadu, ICQ, IRC, Novell Groupwise, QQ,
Lotus Sametime, SILC, Simple and Zephyr.

%package -n libpurple-mini-devel
Summary: Development headers, documentation, and libraries for libpurple
Group: Development/Other
Requires: libpurple-mini = %version-%release
Conflicts: libpurple-devel

%description -n libpurple-mini-devel
This package contains the header files, developer documentation, and
libraries required for development of libpurple based instant
messaging clients or plugins for any libpurple based client.

%if_enabled relnot
%package -n %name-relnot
Summary: Release notification plugin for Pidgin
Group: Networking/Instant messaging
Requires: %name = %version-%release

%description -n %name-relnot
Release notification plugin for Pidgin.
%endif

%if_enabled gevolution
%package -n %name-gevolution
Summary: Gevolution plugin for Pidgin
Group: Networking/Instant messaging
Requires: %name = %version-%release
Obsoletes: gaim-gevolution
Provides: gaim-gevolution = %version

%description -n %name-gevolution
Gevolution plugin for Pidgin.
%endif

%if_enabled mono
%package -n libpurple-mini-mono
Summary: Mono .NET plugin support for Pidgin
Group: Networking/Instant messaging
Requires: libpurple-mini = %version-%release
Obsoletes: gaim-mono
Provides: gaim-mono = %version

%description -n libpurple-mini-mono
Mono support for Pidgin.
%endif

%if_enabled perl
%package -n libpurple-mini-perl
Summary: Perl support for Pidgin
Group: Networking/Instant messaging
Requires: libpurple-mini = %version-%release
Requires: perl-base
Obsoletes: gaim-perl
Provides: gaim-perl = %version

%description -n libpurple-mini-perl
Perl support for Pidgin.
%endif

%if_enabled tcl
%package -n libpurple-mini-tcl
Summary: Tcl/Tk support for Pidgin
Group: Networking/Instant messaging
Requires: libpurple-mini = %version-%release
Obsoletes: gaim-tcl
Provides: gaim-tcl = %version

%description -n libpurple-mini-tcl
Tcl/Tk support for Pidgin.
%endif

%if_enabled consoleui
%package -n finch
Summary: A text-based user interface for Pidgin
Group: Networking/Instant messaging
Requires: libpurple-mini = %version-%release
Provides: gaim-text = %version
Obsoletes: gaim-text

%description -n finch
A text-based user interface for using libpurple.  This can be run from a
standard text console or from a terminal within X Windows.  It
uses ncurses and our homegrown gnt library for drawing windows
and text.

%package -n finch-devel
Summary: Headers etc. for finch stuffs
Group: Development/Other
Requires: finch = %version-%release
Requires: libpurple-mini-devel = %version-%release
Provides: gaim-text-devel = %version
Obsoletes: gaim-text-devel

%description -n finch-devel
The finch-devel package contains the header files, developer
documentation, and libraries required for development of Finch scripts
and plugins.
%endif

%if_enabled dbus
%package -n libpurple-mini-dbus
Summary: D-Bus client utilities for Pidgin
Group: Networking/Instant messaging
Requires: %name = %version-%release
Obsoletes: gaim-dbus
Provides: gaim-dbus = %version

%description -n libpurple-mini-dbus
D-Bus client utilities for Pidgin.
%endif

%prep
%setup -n %oname-%version
%patch0 -p1 -b .resolv
%patch1 -p1
%patch2 -p1 -b .confdir
%patch3 -p2
%patch4 -p1 -b .def_enc
%patch6 -p2
%patch7 -p2

cp %SOURCE2 prefs.xml

# belarusian translation
bzcat %SOURCE1 > po/be.po
# update russian translation
bzcat %SOURCE3 > po/ru.po

sed -i 's,\(ALL_LINGUAS=\"\),\1be ,' configure configure.ac

%build
%autoreconf
%configure \
	--disable-schemas-install \
	%{subst_enable avahi} \
	%{subst_enable dot} \
	%{subst_enable doxygen} \
	%{subst_enable mono} \
	%{subst_enable cap} \
	%{subst_enable nm} \
	%{subst_enable perl} \
	%{subst_enable gevolution} \
	%{subst_enable dbus} \
	%{subst_enable tk} \
	%{subst_enable tcl} \
	%{subst_enable consoleui} \
	%{subst_enable meanwhile} \
	%{subst_enable idn} \
	%{subst_enable farsight} \
	%{subst_enable vv} \
	%{subst_enable gstreamer} \
	%{subst_enable sm} \
	%{subst_enable screensaver} \
	%{subst_enable gestures} \
	%{subst_enable gtkspell} \
	%{subst_enable devhelp} \
%if_disabled startup_notification
	--disable-startup-notification \
%endif
%if_disabled gstreamer
	--disable-gstreamer-interfaces \
%endif
	--with-system-ssl-certs=%_datadir/ca-certificates \
%if_enabled gnutls
	--enable-gnutls=yes \
%else
	--enable-gnutls=no \
%endif
%if_enabled cyrus_sasl
	--enable-cyrus-sasl \
%else
	--disable-cyrus-sasl \
%endif
%if_enabled nss
	--with-nss-includes=%_includedir/nss \
	--with-nspr-includes=%_includedir/nspr \
	--with-nspr-libs=%_libdir \
	--with-nss-libs=%_libdir \
	--enable-nss=yes \
%else
	--enable-nss=no \
%endif
%if_enabled perl
	--with-perl-lib=vendor \
%endif
	--with-extraversion=%release

%make_build

%install
%make DESTDIR=%buildroot install

# install ALTLinux pidgin default prefs.xml
mkdir -p %buildroot%_sysconfdir/purple
install -m 644 prefs.xml %buildroot%_sysconfdir/purple/prefs.xml

find %buildroot%_libdir -name \*.la -delete

%find_lang --with-gnome %oname

%post
%gconf2_install purple

%preun
if [ $1 = 0 ]; then
    %gconf2_uninstall purple
fi

%files -f %oname.lang
%doc AUTHORS COPYRIGHT INSTALL NEWS README README.MTN doc/*.txt
%config %_sysconfdir/gconf/schemas/*
%_bindir/%oname
%_libdir/%oname
%_desktopdir/%oname.desktop
%_pixmapsdir/%oname
%_iconsdir/hicolor/*/apps/*
%_man1dir/%oname.*
%if_enabled perl
%perl_vendor_archlib/Pidgin.pm
%dir %perl_vendor_autolib/Pidgin
%perl_vendor_autolib/Pidgin/*
%perl_vendor_man3dir/Pidgin*
%endif
%if_enabled gevolution
%exclude %_libdir/%oname/gevolution.so
%endif
%if_enabled relnot
%exclude %_libdir/%oname/relnot.so
%endif

%if_enabled relnot
%files -n %name-relnot
%_libdir/%oname/relnot.so
%endif

%files -n libpurple-mini
%config(noreplace) %_sysconfdir/purple
%_libdir/libpurplemini.so.*
%_libdir/purple-2
%_datadir/sounds/purple
%_datadir/purple
%if_enabled tcl
%exclude %_libdir/purple-2/tcl.so
%endif
%if_enabled mono
%exclude %_libdir/purple-2/mono.so
%exclude %_libdir/purple-2/*.dll
%endif
%if_enabled perl
%exclude %_libdir/purple-2/perl.so
%endif

%if_enabled dbus
%files -n libpurple-mini-dbus
%_bindir/purple-client-example
%_bindir/purple-remote
%_bindir/purple-send
%_bindir/purple-send-async
%_bindir/purple-url-handler
%_libdir/libpurple-client.so.*
%endif

%if_enabled gevolution
%files -n %name-gevolution
%_libdir/%oname/gevolution.so
%endif

%if_enabled mono
%files -n libpurple-mini-mono
%_libdir/purple-2/mono.so
%_libdir/purple-2/*.dll
%endif

%if_enabled perl
%files -n libpurple-mini-perl
%_libdir/purple-2/perl.so
%perl_vendor_archlib/Purple.pm
%dir %perl_vendor_autolib/Purple
%perl_vendor_autolib/Purple/*
%perl_vendor_man3dir/Purple*
%endif

%if_enabled tcl
%files -n libpurple-mini-tcl
%_libdir/purple-2/tcl.so
%endif

%if_enabled devel
%files devel
%_includedir/%oname
%_pkgconfigdir/%oname.pc

%files -n libpurple-mini-devel
%doc ChangeLog.API HACKING PLUGIN_HOWTO libpurple/purple-notifications-example
%_includedir/libpurple
%_libdir/libpurple.so
%if_enabled dbus
%_libdir/libpurple-client.so
%endif
%_pkgconfigdir/purple.pc
%_datadir/aclocal/purple.m4
%endif #devel

%if_enabled consoleui
%files -n finch
%_man1dir/finch.*
%_bindir/finch
%_libdir/libgnt.so.*
%_libdir/gnt
%_libdir/finch

%if_enabled devel
%files -n finch-devel
%_includedir/finch
%_includedir/gnt
%_pkgconfigdir/gnt.pc
%_pkgconfigdir/finch.pc
%_libdir/libgnt.so
%endif #devel
%endif #consoleui

%changelog
