%def_with vv
%def_with krb5
%def_enable purple
%def_enable telepathy

Name: pidgin-sipe
Version: 1.15.0
Release: alt1
Summary: Pidgin plugin for connecting to MS Communications Server

Group: Networking/Instant messaging
License: GPLv2+
Url: http://sipe.sourceforge.net/
Packager: Alexey Shabalin <shaba@altlinux.ru>

Source: %name-%version.tar
Patch1: %name-%version-git_snapshot.patch

Requires: libpurple pidgin

BuildRequires: intltool libxml2-devel
BuildRequires: glib2-devel >= 2.28.0
BuildRequires: libpurple-devel >= 2.8.0
%{?_with_vv:BuildRequires: libnice-devel >= 0.1.0 gstreamer-devel}
%{?_with_krb5:BuildRequires: libkrb5-devel}
%{?_enable_telepathy:BuildRequires: libtelepathy-glib-devel >= 0.18.0 libdbus-glib-devel libgio-devel >= 2.28.0}
BuildRequires: libnss-devel
BuildRequires: libgmime-devel >= 2.4.16

%description
A third-party plugin for the Pidgin multi-protocol instant messenger.
It implements the extended version of SIP/SIMPLE used by various products:

    * Microsoft Lync Server 2010
    * Microsoft Office Communications Server (OCS 2007/2007 R2)
    * Microsoft Live Communications Server (LCS 2003/2005)
    * Reuters Messaging

With this plugin you should be able to replace your Microsoft Office
Communicator client with Pidgin.

%package -n telepathy-sipe
Summary: Telepathy connection manager to connect to MS Office Communicator
Group: Networking/Instant messaging

%description -n telepathy-sipe
A Telepathy connection manager that implements the extended version of
SIP/SIMPLE used by various products:

    * Microsoft Lync Server 2010
    * Microsoft Office Communications Server (OCS 2007/2007 R2)
    * Microsoft Live Communications Server (LCS 2003/2005)
    * Reuters Messaging

This package provides the protocol support for Telepathy clients.

%prep
%setup -q
%patch1 -p1

%build
export KRB5_CFLAGS=`krb5-config --cflags`
%autoreconf
%configure \
	--disable-quality-check \
	%{subst_enable purple} \
	%{subst_enable telepathy} \
	%{subst_with vv} \
	%{subst_with krb5}

%make_build

%install
%make DESTDIR=%buildroot install
rm -f %buildroot%_libdir/purple-2/*.la
%find_lang %name

%files -f %name.lang
%doc AUTHORS ChangeLog HACKING COPYING NEWS README TODO
%_libdir/purple-2/libsipe.so
%_pixmapsdir/pidgin/protocols/*/sipe.*

%files -n telepathy-sipe
%_libexecdir/telepathy-sipe
%_datadir/dbus-1/services/*.service
%_datadir/empathy/icons/hicolor/*/apps/im-sipe.*
%_datadir/telepathy/profiles/sipe.profile

%changelog
