%def_without tcl
%def_with python

Name: pilot-link
Version: 0.12.5
Release: alt2.1

Summary: File transfer utilities between Linux and PalmPilots
License: GPL
Group: Communications

URL: http://www.pilot-link.org/
Source: http://downloads.pilot-link.org/pilot-link-%version.tar.bz2

# from Fedora
Patch1: pilot-link-0.12.1-var.patch
Patch2: pilot-link-0.12.2-open.patch
Patch3: pilot-link-0.12.3-clio.patch
Patch4: pilot-link-0.12.5-mp.patch
Patch5: pilot-link-0.12.5-redefinePerlsymbols.patch
Patch6: pilot-link-0.12.5-alt-libpng15.patch

Requires: lib%name = %version-%release

# Automatically added by buildreq on Wed Oct 19 2011
BuildRequires: libbluez-devel libpng-devel libpopt-devel libreadline-devel libusb-compat-devel perl-devel

%if_with tcl
BuildRequires: tcl-devel tk
%endif

%if_with python
BuildRequires: python-devel
%endif

%description
This suite of tools allows you to upload and download programs and
data files between a Linux/UNIX machine and the PalmPilot.  It has a
few extra utils that will allow for things like syncing the
PalmPilot's calendar app with Ical.  Note that you might still need to
consult the sources for pilot-link if you would like the Python, Tcl,
or Perl bindings.

Install pilot-link if you want to synchronize your Palm with your Operating System.

%package -n lib%name
Summary: Shared libraries to use pilot-link
Group: System/Libraries
License: LGPL
PreReq: %_sysconfdir/udev/rules.d

%description -n lib%name
Shared libraries needed to use pilot-link.

%package -n lib%name-devel
Summary: PalmPilot development files
Group: Development/C
License: LGPL
Requires: lib%name = %version-%release
Provides: %name-devel = %version
Obsoletes: %name-devel < %version

%description -n lib%name-devel
This package contains the header and other files that are necessary to build
applications that use pilot-link suite.

You'll need to install libpilot-link-devel if you want to develop
PalmPilot synchronizing applications.

%package -n pilot-debug
Summary: Programs to interact with Palm debug monitor.
Group: Development/Other
Requires: lib%name = %version-%release

%description -n pilot-debug
This package contains utilities that provide command line and
graphical interfaces to the Palm debug monitor.

%package -n perl-%name
Summary: Pilot-link perl bindings
Group: Development/Other
Requires: lib%name = %version-%release

%description -n perl-%name
This package contains pilot-link perl bindings.

%if_with python
%package -n python-module-%name
Summary: Pilot-link python bindings
Group: Development/Other
Requires: lib%name = %version-%release

%description -n python-module-%name
This package contains pilot-link python bindings.
%endif

%prep
%setup -q
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p2

%build
%autoreconf
%configure \
	--disable-static \
	--enable-conduits \
	--enable-threads \
	--enable-libusb \
%if_with python
	--with-python \
%endif
	--with-perl \
%if_with tcl
	--with-tcl=%_libdir \
%endif
	--with-libpng

%make_build

%install
%make_install DESTDIR=%buildroot install
# mandir1='$(mandir)/man1' mandir7='$(mandir)/man7' INSTALL="./libtool /usr/bin/install -p"

mkdir -p %buildroot%_sysconfdir/udev/rules.d
install -p -m644 doc/60-libpisock.rules %buildroot%_sysconfdir/udev/rules.d/75-lib%name.rules

%files
%_bindir/pilot-*
%exclude %_bindir/pilot-debugsh
%if_with tcl
%_bindir/pitclsh
%endif
%_datadir/%name
%doc AUTHORS NEWS doc/*

%files -n lib%name
%_sysconfdir/udev/rules.d/*
%_libdir/libpisock.so.*
%_libdir/libpisync.so.*
%if_with tcl
%_libdir/libpitcl*.so.*
%endif

%files -n lib%name-devel
%_datadir/aclocal/*
%_libdir/libpisock.so
%_libdir/libpisync.so
#_libdir/libpisock++.so
%if_with tcl
%_libdir/libpitcl*.so
%endif
%_includedir/*
%_pkgconfigdir/pilot-link.pc

%files -n pilot-debug
%_bindir/pilot-debugsh

%files -n perl-%name
%perl_vendor_archlib/PDA
%perl_vendor_autolib/PDA

%if_with python
%files -n python-module-%name
%python_sitelibdir/*pisock*
%endif

%changelog
