%define qtdir %_qt3dir
%def_with libcap

Name: pinentry
Version: 0.8.3
Release: alt0.M70P.1

Group: File tools
Summary: Simple PIN or passphrase entry dialog
Url: http://gnupg.org/related_software/pinentry/
License: GPLv2+

Requires: %name-common = %version-%release

Requires: %name-qt = %version-%release
Requires: %name-gtk = %version-%release
Requires: %name-curses = %version-%release

# ftp://ftp.gnupg.org/gcrypt/pinentry/%name-%version.tar.gz
Source: %name-%version.tar
Patch4: 0004-Fix-qt4-pinentry-window-created-in-the-background.patch
# ALT
Patch100: pinentry-0.7.6-alt-system-assuan.patch


# due to qt macros
BuildRequires(pre): libqt3-devel libqt4-devel

%if_with libcap
BuildRequires: libcap-devel
%endif

# Automatically added by buildreq on Sun Feb 07 2010
BuildRequires: gcc-c++ libassuan0-devel libgtk+2-devel libncursesw-devel

%description
This is simple PIN or passphrase entry dialog which
utilize the Assuan protocol as described by the aegypten project.

%package common
Group: %group
Summary: %summary
Conflicts: pinentry < 0.7.2 pinentry-curses < 0.7.2
Conflicts: pinentry-qt < 0.7.2 pinentry-gtk < 0.7.2

%package curses
Group: %group
Summary: %summary
Provides: %name-terminal = %version-%release
Provides: %name = %version-%release
Provides: %_bindir/%name
Requires: %name-common = %version-%release

%package gtk
Group: %group
Summary: %summary
Provides: %name = %version-%release
Provides: %name-x11 = %version-%release
Provides: %_bindir/%name
Requires: %name-common = %version-%release

%package qt
Group: %group
Summary: %summary
Provides: %name = %version-%release
Provides: %_bindir/%name
Provides: %name-x11 = %version-%release
Requires: libqt4-core >= %{get_version libqt4-core}
Requires: %name-common = %version-%release

%package qt3
Group: %group
Summary: %summary
Provides: %name = %version-%release
Provides: %_bindir/%name
Provides: %name-x11 = %version-%release
Requires: libqt3 >= %{get_version libqt3}
Requires: %name-common = %version-%release

%description curses
This is simple PIN or passphrase entry dialog which
utilize the Assuan protocol as described by the aegypten project.

%description gtk
This is simple PIN or passphrase entry dialog which
utilize the Assuan protocol as described by the aegypten project.

%description qt
This is simple PIN or passphrase entry dialog which
utilize the Assuan protocol as described by the aegypten project.

%description qt3
This is simple PIN or passphrase entry dialog which
utilize the Assuan protocol as described by the aegypten project.

%description common
This package contains common files and documentation for %name.

%prep
%setup
%patch4 -p1
%patch100 -p1

rm doc/*.info

pushd qt4
for h in pinentrydialog.h qsecurelineedit.h; do
    m="${h%%.h}.moc"
    rm $m
    moc-qt4 $h -o $m
done
popd

%build
%autoreconf
export QTDIR=%qtdir

%configure \
    --disable-rpath \
    --disable-pinentry-gtk \
    --enable-pinentry-gtk2 \
    --enable-pinentry-qt \
    --enable-pinentry-qt4 \
    --enable-pinentry-curses \
    %{subst_with libcap} \
    #

%make_build

%install
%makeinstall_std
rm %buildroot%_bindir/%name
mv %buildroot%_bindir/%name-gtk{-2,}
mv %buildroot%_bindir/%name-qt{,3}
mv %buildroot%_bindir/%name-qt{4,}

mkdir -p %buildroot%_altdir
WEIGHT=10
for i in curses qt3 gtk qt; do
cat >%buildroot%_altdir/%name-$i<<EOF
%_bindir/%name	%_bindir/%name-$i	$WEIGHT
EOF
((WEIGHT+=10))
done

%files curses
%_altdir/%name-curses
%_bindir/%name-curses

%files gtk
%_altdir/%name-gtk
%_bindir/%name-gtk

%files qt
%_altdir/%name-qt
%_bindir/%name-qt

%files qt3
%_altdir/%name-qt3
%_bindir/%name-qt3

%files common
%doc AUTHORS NEWS README THANKS
%_infodir/*.info*

%changelog
