%define popIF_ver_gt() %if "%(rpmvercmp '%1' '%2')" > "0"
%define popIF_ver_gteq() %if "%(rpmvercmp '%1' '%2')" >= "0"
%define popIF_ver_lt() %if "%(rpmvercmp '%2' '%1')" > "0"
%define popIF_ver_lteq() %if "%(rpmvercmp '%2' '%1')" >= "0"

%def_disable static
%def_disable compat

%if_disabled compat
%def_enable cpp
%def_enable glib
%def_enable qt5
%def_enable qt4
%def_disable qt3
%def_enable devel
%def_enable utils
%def_enable xpdfheaders
%def_enable gir
%else
%def_disable cpp
%def_disable glib
%def_disable qt5
%def_disable qt4
%def_disable qt3
%def_disable devel
%def_disable utils
%def_disable xpdfheaders
%def_disable gir
%endif

%define rname poppler
%define somajor 43
%define somajor_cpp 0
%define somajor_qt 3
%define somajor_qt4 4
%define somajor_qt5 1
%define somajor_glib 8
%define major 0
%define minor 24
%define bugfix 3
Name: %rname%somajor
Version: %major.%minor.%bugfix
Release: alt1.M70P.1

%if_disabled compat
%define poppler_devel_name lib%rname-devel
%define poppler_cpp_devel_name lib%rname-cpp-devel
%define poppler_glib_devel_name lib%rname-glib-devel
%define poppler_qt_devel_name lib%rname-qt-devel
%define poppler_qt4_devel_name lib%rname-qt4-devel
%define poppler_qt5_devel_name lib%rname-qt5-devel
%else
%define poppler_devel_name lib%rname%somajor-devel
%define poppler_cpp_devel_name lib%rname%somajor-cpp-devel
%define poppler_glib_devel_name lib%rname%somajor-glib-devel
%define poppler_qt_devel_name lib%rname%somajor-qt-devel
%define poppler_qt4_devel_name lib%rname%somajor-qt4-devel
%define poppler_qt5_devel_name lib%rname%somajor-qt5-devel
%endif

Group: Publishing
Summary: PDF rendering library
License: GPL
Url: http://poppler.freedesktop.org/
Packager: Sergey V Turchin <zerg at altlinux dot org>

Source: %rname-%version.tar
# FC
Patch10: poppler-0.24.2-mocversiongrep.patch

# Automatically added by buildreq on Fri Apr 01 2011 (-bi)
#BuildRequires: gcc-c++ glib-networking glibc-devel-static gtk-doc gvfs imake libXt-devel libcurl-devel libgtk+2-devel libgtk+2-gir-devel libjpeg-devel liblcms-devel libopenjpeg-devel libqt3-devel libqt4-devel libqt4-gui libqt4-xml libxml2-devel python-modules-compiler python-modules-encodings time xorg-cf-files

BuildRequires(pre): rpm-utils
%if_enabled qt5
BuildRequires: qt5-base-devel
%endif
%if_enabled qt4
BuildRequires: libqt4-devel
%endif
%if_enabled glib
BuildRequires: glib2-devel
%endif
BuildRequires: gcc-c++ glibc-devel libcurl-devel libgtk+2-devel zlib-devel
BuildRequires: libgtk+2-gir-devel libjpeg-devel liblcms2-devel libopenjpeg-devel libtiff-devel
BuildRequires: libxml2-devel gtk-doc libcairo-gobject-devel
BuildRequires: libXt-devel

%description
Poppler is a fork of the xpdf PDF viewer developed by Derek Noonburg
of Glyph and Cog, LLC.  The purpose of forking xpdf is twofold.
First, we want to provide PDF rendering functionality as a shared
library, to centralize the maintenence effort.  Today a number of
applications incorporate the xpdf code base, and whenever a security
issue is discovered, all these applications exchange patches and put
out new releases.  In turn, all distributions must package and release
new version of these xpdf based viewers.  It's safe to say that
there's a lot of duplicated effort with the current situaion.  Even if
poppler in the short term introduces yet another xpdf derived code
base to the world, we hope that over time these applications will
adopt poppler.  After all, we only need one application to use poppler
to break even.

%package -n lib%name
Summary: PDF rendering library
Group: System/Libraries
Requires: poppler-data
%description -n lib%name
Poppler is a fork of the xpdf PDF viewer developed by Derek Noonburg
of Glyph and Cog, LLC.  The purpose of forking xpdf is twofold.
First, we want to provide PDF rendering functionality as a shared
library, to centralize the maintenence effort.  Today a number of
applications incorporate the xpdf code base, and whenever a security
issue is discovered, all these applications exchange patches and put
out new releases.  In turn, all distributions must package and release
new version of these xpdf based viewers.  It's safe to say that
there's a lot of duplicated effort with the current situaion.  Even if
poppler in the short term introduces yet another xpdf derived code
base to the world, we hope that over time these applications will
adopt poppler.  After all, we only need one application to use poppler
to break even.

%package -n %rname
Group: Publishing
Summary: PDF rendering library utils
Requires: lib%name = %version-%release
Provides: poppler-utils = %version-%release
Provides: xpdf-utils = 3.02-alt6
Obsoletes: xpdf-utils <= 3.02-alt5
Conflicts: xpdf-reader <= 3.02-alt5
Conflicts: pdftohtml
%description -n %rname
Poppler is a fork of the xpdf PDF viewer developed by Derek Noonburg
of Glyph and Cog, LLC.  The purpose of forking xpdf is twofold.
First, we want to provide PDF rendering functionality as a shared
library, to centralize the maintenence effort.  Today a number of
applications incorporate the xpdf code base, and whenever a security
issue is discovered, all these applications exchange patches and put
out new releases.  In turn, all distributions must package and release
new version of these xpdf based viewers.  It's safe to say that
there's a lot of duplicated effort with the current situaion.  Even if
poppler in the short term introduces yet another xpdf derived code
base to the world, we hope that over time these applications will
adopt poppler.  After all, we only need one application to use poppler
to break even.

%package -n lib%rname%somajor_qt5-qt5
Summary: Qt5 frontend library for %rname
Group: System/Libraries
Requires: lib%name = %version-%release
%description -n lib%rname%somajor_qt5-qt5
Qt5 frontend library for %rname

%package -n lib%rname%somajor_qt4-qt4
Summary: Qt4 frontend library for %rname
Group: System/Libraries
Requires: lib%name = %version-%release
%popIF_ver_gteq "%major.%minor" "0.10"
Provides: libpoppler08-qt4 = %version-%release
Obsoletes: libpoppler08-qt4 < %version-%release
%if "%somajor_qt4" != "4"
Provides: libpoppler4-qt4 = %version-%release
Obsoletes: libpoppler4-qt4 < %version-%release
%endif
%endif
%description -n lib%rname%somajor_qt4-qt4
Qt4 frontend library for %rname

%package -n lib%rname%somajor_glib-glib
Summary: Glib frontend library for %rname
Group: System/Libraries
Requires: lib%name = %version-%release
%description -n lib%rname%somajor_glib-glib
Glib frontend library for %rname

%package -n lib%rname%somajor_cpp-cpp
Summary: Pure C++ wrapper for poppler
Group: System/Libraries
Requires: lib%name = %version-%release
%description -n lib%rname%somajor_cpp-cpp
Pure C++ wrapper for poppler


%package -n %poppler_devel_name
Summary: Development files for %rname
Group: Development/C
Provides: lib%name-devel = %version-%release
Obsoletes: lib%name-devel < %version-%release
Requires: lib%name = %version-%release
%if_enabled compat
Conflicts: lib%rname-devel
%endif
%description -n %poppler_devel_name
Libraries, include files, etc you can use to develop poppler applications

%package -n %poppler_cpp_devel_name
Summary: Development files for C++ wrapper
Group: Development/C++
Requires: lib%rname%somajor_cpp-cpp = %version-%release
Requires: %poppler_devel_name = %version-%release
%if_enabled compat
Conflicts: lib%rname-cpp-devel
%endif
%description -n %poppler_cpp_devel_name
Libraries, include files, etc you can use to develop
poppler applications with pure C++

%package -n %poppler_glib_devel_name
Summary: Development files for %rname-glib
Group: Development/GNOME and GTK+
Requires: lib%rname%somajor_glib-glib = %version-%release
Requires: %poppler_devel_name = %version-%release
%if_enabled compat
Conflicts: lib%rname-glib-devel
%endif
%description -n %poppler_glib_devel_name
Libraries, include files, etc you can use to develop
poppler applications with Glib/Gtk+

%package -n %poppler_qt5_devel_name
Summary: Development files for %rname-qt5
Group: Development/KDE and QT
Requires: lib%rname%somajor_qt5-qt5 = %version-%release
Requires: %poppler_devel_name = %version-%release
%if_enabled compat
Conflicts: lib%rname-qt5-devel
%endif
%description -n %poppler_qt5_devel_name
Libraries, include files, etc you can use to develop
poppler applications with Qt5

%package -n %poppler_qt4_devel_name
Summary: Development files for %rname-qt4
Group: Development/KDE and QT
Requires: lib%rname%somajor_qt4-qt4 = %version-%release
Requires: %poppler_devel_name = %version-%release
%if_enabled compat
Conflicts: lib%rname-qt4-devel
%endif
%description -n %poppler_qt4_devel_name
Libraries, include files, etc you can use to develop
poppler applications with Qt4

%package -n lib%rname-gir
Summary: GObject introspection data for the Poppler library
Group: System/Libraries
Requires: lib%rname%somajor_glib-glib = %version-%release
%description -n lib%rname-gir
GObject introspection data for the Poppler library

%package -n lib%rname-gir-devel
Summary: GObject introspection devel data for the Poppler library
Group: System/Libraries
BuildArch: noarch
Requires: lib%rname-gir = %version-%release
Requires: %poppler_glib_devel_name = %version-%release
%description -n lib%rname-gir-devel
GObject introspection devel data for the Poppler library

%package -n %{poppler_devel_name}-static
Summary: Static libraries for lib%rname
Group: Development/Other
Provides: lib%name-devel-static = %version-%release
Obsoletes: lib%name-devel-static < %version-%release
Requires: %poppler_devel_name = %version-%release
%description -n %{poppler_devel_name}-static
This package contains development libraries required for packaging
statically linked libpoppler-based software

%prep
%setup -q -n %rname-%version
%patch10 -p1

chmod a-x goo/GooTimer.h

%autoreconf
#aclocal --force -I m4
#automake
#autoconf --force

%build
%if_enabled qt4
export QT4DIR=%_qt4dir
%endif
%configure \
    --disable-rpath \
    %{subst_enable static} \
    --enable-shared \
    --enable-compile-warnings=yes \
    --enable-introspection=yes \
    --enable-libcurl \
    --enable-zlib \
%if_enabled xpdfheaders
    --enable-xpdf-headers \
%endif
%if_disabled cpp
    --disable-poppler-cpp \
%endif
%if_disabled glib
    --disable-poppler-glib \
%endif
%if_disabled qt4
    --disable-poppler-qt4 \
%endif
%if_enabled qt5
    --enable-poppler-qt5 \
%else
    --disable-poppler-qt5 \
%endif
    #

%make_build

%install
%makeinstall

%if_enabled utils
%files -n %rname
%_bindir/pdf*
%_man1dir/pdf*
%endif

%files -n lib%name
%doc AUTHORS ChangeLog NEWS README* TODO
%_libdir/libpoppler.so.%somajor
%_libdir/libpoppler.so.%somajor.*

%if_enabled gir
%files -n lib%rname-gir
%_typelibdir/Poppler-*.typelib
%if_enabled devel
%files -n lib%rname-gir-devel
%_girdir/Poppler-*.gir
%endif
%endif

%if_enabled glib
%files -n lib%rname%somajor_glib-glib
%_libdir/libpoppler-glib.so.%somajor_glib
%_libdir/libpoppler-glib.so.%somajor_glib.*
%if_enabled devel
%files -n %poppler_glib_devel_name
%_includedir/poppler/glib/
%_libdir/libpoppler-glib.so
%_pkgconfigdir/poppler-cairo.pc
%_pkgconfigdir/poppler-glib.pc
%endif
%endif

%if_enabled qt4
%files -n lib%rname%somajor_qt4-qt4
%_libdir/libpoppler-qt4.so.%somajor_qt4
%_libdir/libpoppler-qt4.so.%somajor_qt4.*
%if_enabled devel
%files -n %poppler_qt4_devel_name
%_includedir/poppler/qt4/
%_libdir/libpoppler-qt4.so
%_pkgconfigdir/poppler-qt4.pc
%endif
%endif

%if_enabled qt5
%files -n lib%rname%somajor_qt5-qt5
%_libdir/libpoppler-qt5.so.%somajor_qt5
%_libdir/libpoppler-qt5.so.%somajor_qt5.*
%if_enabled devel
%files -n %poppler_qt5_devel_name
%_includedir/poppler/qt5/
%_libdir/libpoppler-qt5.so
%_pkgconfigdir/poppler-qt5.pc
%endif
%endif

%if_enabled cpp
%files -n lib%rname%somajor_cpp-cpp
%_libdir/libpoppler-cpp.so.%somajor_cpp
%_libdir/libpoppler-cpp.so.%somajor_cpp.*
%if_enabled devel
%files -n %poppler_cpp_devel_name
%_includedir/poppler/cpp/
%_libdir/libpoppler-cpp.so
%_pkgconfigdir/poppler-cpp.pc
%endif
%endif

%if_enabled devel
%files -n %poppler_devel_name
%dir %_includedir/poppler
%_includedir/poppler/*.h
#%_includedir/poppler/Function.cc
%_includedir/poppler/fofi
%_includedir/poppler/splash/
%_includedir/poppler/goo/
%_libdir/libpoppler.so
%_pkgconfigdir/poppler.pc
%_pkgconfigdir/poppler-splash.pc
#%_datadir/gtk-doc/html/poppler

%if_enabled static
%files -n %{poppler_devel_name}-static
%_libdir/*.a
%endif
%endif

%changelog
