Name: privoxy
Version: 3.0.16
Release: alt2

Summary: Privoxy - privacy enhancing proxy
License: GPLv2+
Group: Networking/WWW
Url: http://www.privoxy.org/
Packager: Sviatoslav Sviridov <svd@altlinux.ru>

Source0: %name-%version.tar
Source1: %name.chroot.lib
Source2: %name.chroot.conf
Source3: %name.chroot.log
Source4: %name.chroot.all
Source5: %name.init
Source6: %name.log
Source7: %name.default.action

Patch1: %name-3.0.10-alt-config.patch

PreReq: chkconfig, shadow-utils, chrooted, coreutils

# Root directory for chrooted environment, must not be same as real system root.
%define ROOT /var/lib/%name

# Automatically added by buildreq on Thu Sep 19 2002
BuildRequires: docbook-style-dsssl libpcre-devel

%description
Privoxy is a web proxy with advanced filtering capabilities for protecting
privacy, filtering web page content, managing cookies, controlling access, and
removing ads, banners, pop-ups and other obnoxious Internet junk. Privoxy has a
very flexible configuration and can be customized to suit individual needs and
tastes. Privoxy has application for both stand-alone systems and multi-user
networks.

Privoxy is based on the Internet Junkbuster.
Privoxy runs in safe chrooted environment with own uid and gid.

%prep
%setup -n %name-%version

%patch1 -p2

cp -p $RPM_SOURCE_DIR/%name.{init,log,chroot.{lib,conf,log,all}} .
%__subst -p 's|%%name|%name|g; s|%%ROOT|%ROOT|g' %name.{init,log,chroot.{lib,conf,log,all}} config
#cp -p %SOURCE7 ./default.action.master

%build
%__autoheader
%__autoconf

export ac_cv_prog_GDB=yes
export ac_cv_prog_WDUMP=lynx
export ac_cv_prog_DB2HTML=db2html
export ac_cv_prog_JADEBIN=openjade
export ac_cv_prog_MAN2HTML=man2html
%configure

%make_build

%install
# From junkbuster.spec
install -pD -m755 %name %buildroot%_sbindir/%name
install -pD -m644 %name.1 %buildroot%_man8dir/%name.8
install -pD -m640 %name.log %buildroot%_sysconfdir/logrotate.d/%name
install -pD -m755 %name.init %buildroot%_initdir/%name

mkdir -p %buildroot%ROOT{%_sbindir,/lib,/var/{nis,yp/binding,log},%_sysconfdir/%name/templates}
install -p config trust {default,match-all,user}.action {default,user}.filter %buildroot%ROOT/%_sysconfdir/%name/
install -p templates/[a-z]* %buildroot%ROOT/%_sysconfdir/%name/templates/

install -pD -m750 %name.chroot.lib %buildroot%_sysconfdir/chroot.d/%name.lib
install -pD -m750 %name.chroot.conf %buildroot%_sysconfdir/chroot.d/%name.conf
install -pD -m750 %name.chroot.log %buildroot%_sysconfdir/chroot.d/%name.log
install -pD -m750 %name.chroot.all %buildroot%_sysconfdir/chroot.d/%name.all

touch %buildroot%ROOT{/var/log/{%name,jarfile},%_sysconfdir/{hosts,{host,nsswitch,resolv}.conf},/var/nis/NIS_COLD_START}

%pre
/usr/sbin/groupadd -r -f %name
/usr/sbin/useradd -r -g %name -d %ROOT -s /dev/null -c 'The Privoxy web proxy' %name >/dev/null 2>&1 ||:
if [ $1 -gt 1 ]; then
	/usr/sbin/usermod -d %ROOT %name
fi

%post
%_sysconfdir/chroot.d/%name.all force
%post_service %name
test -d %_sysconfdir/%name/ || ln -s %ROOT%_sysconfdir/%name %_sysconfdir/%name

%preun
%preun_service %name
if [ $1 = 0 ]; then
	rm -f %ROOT/lib/* %ROOT/var/yp/binding/*
	rm -f %_sysconfdir/%name
fi

# between 3.0.10 and 3.0.16 regular action file is renamed
%triggerun -- %name < 3.0.16
if [ $2 -gt 0 ]; then
    %__subst "s|^actionsfile standard.action|actionsfile match-all.action|g" %ROOT%_sysconfdir/%name/config
fi

%files
%config(noreplace) %_sysconfdir/logrotate.d/*
%config %_initdir/%name
%config %_sysconfdir/chroot.d/*
%_sbindir/*
%_mandir/man?/*
%doc README AUTHORS doc/webserver/user-manual/[a-z]*

%defattr(640,root,%name,710)
%dir %ROOT
%dir %ROOT/lib
%dir %ROOT%_sysconfdir
%dir %ROOT%_sysconfdir/%name
%ROOT%_sysconfdir/%name/templates
%config(noreplace) %ROOT%_sysconfdir/%name/config
%config(noreplace) %ROOT%_sysconfdir/%name/user.action
%config(noreplace) %ROOT%_sysconfdir/%name/user.filter
%config %ROOT%_sysconfdir/%name/default.action
%config %ROOT%_sysconfdir/%name/default.filter
%config %ROOT%_sysconfdir/%name/match-all.action
%config %ROOT%_sysconfdir/%name/trust
%dir %ROOT/var
%dir %ROOT/var/log
%dir %ROOT/var/nis
%ghost %ROOT/var/nis/NIS_COLD_START
%dir %ROOT/var/yp
%dir %ROOT/var/yp/binding

%defattr(644,root,root,710)
%ghost %ROOT%_sysconfdir/hosts
%ghost %ROOT%_sysconfdir/*.conf
%ghost %attr(660,root,%name) %ROOT/var/log/jarfile
%ghost %attr(660,root,%name) %ROOT/var/log/%name

%changelog
