%def_enable shared
%def_enable static
%def_enable nls

Name: progsreiserfs
%define lname lib%name
Version: 0.3.0.5
Release: alt2
Summary: Programs needed for manipulating reiserfs partitions
Summary(uk_UA.CP1251):       reiserfs
License: %gpl2plus
Group: System/Configuration/Hardware
# Url: ftp://ftp.namesys.com/pub/libreiserfs/
Source: %name-%version.tar
Patch: %name-%version-m4.patch
%{?_enable_shared:Requires: %lname = %version-%release}

BuildPreReq: rpm-build-licenses
BuildRequires: libuuid-devel

%description
%name is a package that allows you to create, destroy, resize and copy
reiserfs filesystem.

%description -l uk_UA.CP1251
%name - ,   , ,   
   reiserfs.


%if_enabled shared
%package -n %lname
Summary: Shared library for reiserfs utilities
Group: System/Libraries

%description -n %lname
This package includes the shared library needed to run %lname-based
software.
%endif


%package -n %lname-devel
Summary: Files required to compile software that uses %lname
Group: Development/C
Requires: %lname%{?_disable_shared:-devel-static} = %version-%release

%description -n %lname-devel
This package includes the header files for %lname.


%if_enabled static
%package -n %lname-devel-static
Summary: Files required to compile statically linked software that uses %lname
Group: Development/C
Requires: %lname = %version-%release

%description -n %lname-devel-static
This package includes the libraries needed to statically link software with
%lname.
%endif

%prep
%setup -q
%patch -p1
sed -i -r 's/(mkfs)\.(reiserfs)/\2.\1/g' doc/mkfs.reiserfs.8
[ -e config.rpath ] || :> config.rpath


%build
%autoreconf -fisv
%configure \
	%{subst_enable shared} \
	%{subst_enable static} \
	%{subst_enable nls} \
	--enable-threads=posix \
	--enable-largefile \
	--disable-rpath \
	--with-gnu-ld
%make_build
gzip -9c ChangeLog > ChangeLog.gz


%install
%makeinstall_std
mv %buildroot%_sbindir/{mkfs.reiserfs,reiserfs.mkfs}
mv %buildroot%_man8dir/{mkfs.reiserfs,reiserfs.mkfs}.8


%if_enabled shared
%files -n %lname
%_libdir/*.so.*
%endif


%files -n %lname-devel
%{?_enable_shared:%_libdir/*.so}
%_includedir/*
%_datadir/aclocal/*


%if_enabled static
%files -n %lname-devel-static
%_libdir/*.a
%endif


%files
%doc AUTHORS ChangeLog.* NEWS README THANKS
%_sbindir/*
%_man8dir/*


%changelog
