Name: pure
Version: 0.57
Release: alt2

Summary: A term-rewriting functional programming language
License: GPLv3+
Group: Development/Functional
Url: http://purelang.bitbucket.org
# https://bitbucket.org/purelang/pure-lang/downloads/%name-%version.tar.gz
Source: %name-%version.tar
# FC patches
Patch100:	pure-0.57-libedit-history.patch
Patch101:	pure-0.57-llvm-3.3.patch

#Requires: pure-doc
#Requires:		web_browser
#Requires: w3m

Requires: libpure = %version-%release

# Automatically added by buildreq on Sat Mar 28 2009
BuildRequires: gcc-c++ flex libelf-devel libffi-devel libgmp-devel libgsl-devel libreadline-devel libmpfr-devel llvm-devel

%description
Pure is a functional programming language based on term rewriting.
It has a modern syntax featuring curried function applications,
lexical closures and equational definitions with pattern matching,
and thus is somewhat similar to languages of the Haskell and ML
variety.  But Pure is also a very dynamic and reflective language,
and is more like Lisp in this respect.  The interpreter has an
LLVM backend to do JIT compilation, hence programs run blazingly
fast and interfacing to C modules is easy.

%package -n libpure
Summary: Shared libraries for PURE
License: LGPLv3+
Group: System/Libraries

%description -n libpure
Shared libraries for PURE.

%package -n libpure-devel
Summary: Include Files and libraries mandatory for development
Group: Development/C++
License: LGPLv3+
Requires: libpure = %version-%release

%description -n libpure-devel
This package contains all necessary include files and libraries
needed to develop applications that require these.

#%package complete
#Summary: Virtual package to install pure and all its components
#Group: Development/Tools/Other
#Requires: pure-csv
#Requires: pure-doc
#Requires: pure-ffi
#Requires: pure-gl
#Requires: pure-gsl
#Requires: pure-odbc
#Requires: pure-xml
#
#%description complete
#Virtual package to install pure and all its components:
#pure-ffi, pure-csv and pure-gsl.

%package examples
Summary: Some examples for pure
Group: Development/Functional
License: GPLv3+
Requires: pure = %version-%release
BuildArch: noarch

%description examples
This package contains examples for programming in pure.

%prep
%setup -n %name-%version
%patch100 -p1
%patch101 -p2

%build
%configure
%make_build PIC='%optflags_shared'

%install
%makeinstall_std

%check
make check

%files
%_bindir/pure
%_libdir/pure/
%exclude %_libdir/pure/*.?
%_man1dir/*
%doc NEWS README TODO
# TODO: etc/* are separate packages for vim, emacs, gedit, kate and libhighlight
%doc etc

%files -n libpure
%_libdir/*.so.*

%files -n libpure-devel
%_includedir/*
%_libdir/*.so
%dir %_libdir/pure/
%_libdir/pure/*.?
%_pkgconfigdir/%name.pc

%files examples
%doc examples

%changelog
