# test new macroses
%define python_build CFLAGS="%optflags" python setup.py build
%define python_install python setup.py install --root %buildroot --optimize=2

%def_with python3

%define oname BeautifulSoup4
Name: python-module-%oname
Version: 4.1.3
Release: alt2

Summary: HTML/XML parser for quick-turnaround applications like screen-scraping

License: PSF
Group: Development/Python
Url: http://www.crummy.com/software/BeautifulSoup/

BuildArch: noarch

%setup_python_module %oname

Source: BeautifulSoup-%version.tar.bz2

# Automatically added by buildreq on Sat May 26 2007
BuildRequires: python-devel python-modules-compiler python-modules-encodings
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python-tools-2to3
%endif

%description
Beautiful Soup parses a (possibly invalid) XML or HTML document into a
tree representation. It provides methods and Pythonic idioms that make
it easy to navigate, search, and modify the tree.

%package tests
Summary: Tests for BeautifulSoup4
Group: Development/Python
Requires: %name = %version-%release

%description tests
Beautiful Soup parses a (possibly invalid) XML or HTML document into a
tree representation. It provides methods and Pythonic idioms that make
it easy to navigate, search, and modify the tree.

This package contains tests for BeautifulSoup4.

%if_with python3
%package -n python3-module-%oname
Summary: HTML/XML parser for quick-turnaround applications like screen-scraping (Python 3)
Group: Development/Python3

%description -n python3-module-%oname
Beautiful Soup parses a (possibly invalid) XML or HTML document into a
tree representation. It provides methods and Pythonic idioms that make
it easy to navigate, search, and modify the tree.

%package -n python3-module-%oname-tests
Summary: Tests for BeautifulSoup4 (Python 3)
Group: Development/Python3
Requires: python3-module-%oname = %version-%release

%description -n python3-module-%oname-tests
Beautiful Soup parses a (possibly invalid) XML or HTML document into a
tree representation. It provides methods and Pythonic idioms that make
it easy to navigate, search, and modify the tree.

This package contains tests for BeautifulSoup4.
%endif

%prep
%setup -n BeautifulSoup-%version
%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%build
%python_build
%if_with python3
pushd ../python3
find -type f -name '*.py' -exec 2to3 -w '{}' +
%python3_build
popd
%endif

%install
%python_install
%if_with python3
pushd ../python3
%python3_install
popd
%endif

%check
python -m unittest discover -s bs4

%files
%doc *.txt
%python_sitelibdir/*
%exclude %python_sitelibdir/bs4/test*

%files tests
%python_sitelibdir/bs4/test*

%if_with python3
%doc *.txt
%files -n python3-module-%oname
%python3_sitelibdir/*
%exclude %python3_sitelibdir/bs4/test*

%files -n python3-module-%oname-tests
%python3_sitelibdir/bs4/test*
%endif

%changelog
