%define oname BlockCanvas
Name: python-module-%oname
Version: 4.0.2
Release: alt1.git20120221
Summary: Enthought Numerical Modeling

Group: Development/Python
License: BSD and GPLv2
URL: http://www.enthought.com/
# https://github.com/enthought/blockcanvas.git
Source: %oname-%version.tar.gz
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

BuildRequires: python-devel, python-module-setuptools
BuildPreReq: python-module-setupdocs
BuildPreReq: python-module-sphinx python-module-Pygments

%description
The BlockCanvas project provides a visual environment for creating simulation
experiments, where function and data are separated. Thus, you can define your
simulation algorithm by visually connecting function blocks into a data flow
network, and then run it with various data sets (known as "contexts");
likewise, you can use the same context in a different functional simulation.

The project provides support for plotting, function searching and inspection,
and optimization. It includes a stand-alone application that demonstrates the
block-canvas environment, but the same functionality can be incorporated into
other applications.

The BlockCanvas project relies on included libraries that allow multiple data
sets using Numeric arrays to be incorporated in a Traits-based model in a way
that is simple, fast, efficient, and consistent.

%package tests
Summary: Tests for Enthought Numerical Modeling
Group: Development/Documentation
Requires: %name = %version-%release

%description tests
The BlockCanvas project provides a visual environment for creating simulation
experiments, where function and data are separated. Thus, you can define your
simulation algorithm by visually connecting function blocks into a data flow
network, and then run it with various data sets (known as "contexts");
likewise, you can use the same context in a different functional simulation.

This package contains tests for BlockCanvas.

%prep
%setup

%build
%python_build_debug

%install
%python_install

%files
%doc *.txt docs/*.txt docs/model/*
%python_sitelibdir/*
%exclude %python_sitelibdir/*/*/tests
%exclude %python_sitelibdir/*/*/*/tests
%exclude %python_sitelibdir/*/*/*/*/tests
%exclude %python_sitelibdir/*/*/*/*/*/tests

%files tests
%python_sitelibdir/*/*/tests
%python_sitelibdir/*/*/*/tests
%python_sitelibdir/*/*/*/*/tests
%python_sitelibdir/*/*/*/*/*/tests

%changelog
