%define _name Cython
%define bname %{_name}0.18

%def_with python3

Name: python-module-%bname
Version: 0.18
Release: alt1

Summary: C-extensions for Python
Group: Development/Python
License: Python
Url: http://www.cython.org

# http://www.cython.org/release/Cython-%version.tar.gz
# git://github.com/cython/cython.git
Source: %name-%version.tar

Provides: %_name = %EVR
Provides: python-module-%_name = %EVR
Obsoletes: %_name < 0.18

BuildPreReq: rpm-build-python
BuildPreReq: python-devel python-module-setuptools

%description
Cython is a language that makes writing C extensions for the Python
language as easy as Python itself. Cython is based on the well-known
Pyrex, but supports more cutting edge functionality and optimizations.

The Cython language is very close to the Python language, but Cython
additionally supports calling C functions and declaring C types on
variables and class attributes. This allows the compiler to generate
very efficient C code from Cython code.

This makes Cython the ideal language for wrapping for external C
libraries, and for fast C modules that speed up the execution of Python
code.

%if_with python3
%package -n python3-module-%bname
Summary: C-extensions for Python3
Group: Development/Python3
Provides: python3-module-%_name = %EVR
Obsoletes: python3-module-%_name < 0.18
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-distribute

%description -n python3-module-%bname
Cython is a language that makes writing C extensions for the Python3
language as easy as Python3 itself. Cython is based on the well-known
Pyrex, but supports more cutting edge functionality and optimizations.

The Cython language is very close to the Python3 language, but Cython
additionally supports calling C functions and declaring C types on
variables and class attributes. This allows the compiler to generate
very efficient C code from Cython code.

This makes Cython the ideal language for wrapping for external C
libraries, and for fast C modules that speed up the execution of Python3
code.
%endif

%prep
%setup
%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%build
%python_build
%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%if_with python3
pushd ../python3
%python3_install
popd
mv %buildroot/%_bindir/cython %buildroot/%_bindir/cython3
mv %buildroot/%_bindir/cygdb %buildroot/%_bindir/cygdb3
%endif

%python_install

%files
%_bindir/cython
%python_sitelibdir/pyximport/
%python_sitelibdir/%_name/
%python_sitelibdir/%_name-*egg-info
%python_sitelibdir/cython.py*
%doc *.txt Demos Doc Tools

# don't package tests files and debugger
%exclude %python_sitelibdir/%_name/Tests
%exclude %python_sitelibdir/%_name/*/Tests
%exclude %python_sitelibdir/%_name/Debugger
%exclude %_bindir/cygdb

%if_with python3
%files -n python3-module-%bname
%_bindir/cython3
%python3_sitelibdir/%_name/
%python3_sitelibdir/pyximport/
%python3_sitelibdir/cython.py
%python3_sitelibdir/__pycache__/cython.*
%python3_sitelibdir/*egg-info

# don't package tests files and debugger
%exclude %python3_sitelibdir/%_name/Tests
%exclude %python3_sitelibdir/%_name/*/Tests
%exclude %python3_sitelibdir/%_name/Debugger
%exclude %_bindir/cygdb3
%endif

%changelog
