%define oname DateTime

%def_with python3

Name: python-module-%oname
Epoch: 1
Version: 4.0
Release: alt1
Summary: Encapsulation of date/time values
License: ZPLv2.1
Group: Development/Python
Url: http://pypi.python.org/pypi/DateTime/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

Source: %name-%version.tar
BuildArch: noarch

BuildPreReq: python-devel python-module-distribute
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-distribute
BuildPreReq: python-tools-2to3
%endif

%description
This package provides a DateTime data type, as known from Zope 2. Unless
you need to communicate with Zope 2 APIs, you're probably better off
using Python's built-in datetime module.

%if_with python3
%package -n python3-module-%oname
Summary: Encapsulation of date/time values (Python 3)
Group: Development/Python3

%description -n python3-module-%oname
This package provides a DateTime data type, as known from Zope 2. Unless
you need to communicate with Zope 2 APIs, you're probably better off
using Python's built-in datetime module.

%package -n python3-module-%oname-tests
Summary: Tests for DateTime (Python 3)
Group: Development/Python3
Requires: python3-module-%oname = %EVR

%description -n python3-module-%oname-tests
This package provides a DateTime data type, as known from Zope 2. Unless
you need to communicate with Zope 2 APIs, you're probably better off
using Python's built-in datetime module.

This package contains tests for DateTime.
%endif

%package tests
Summary: Tests for DateTime
Group: Development/Python
Requires: %name = %EVR

%description tests
This package provides a DateTime data type, as known from Zope 2. Unless
you need to communicate with Zope 2 APIs, you're probably better off
using Python's built-in datetime module.

This package contains tests for DateTime.

%prep
%setup
%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%build
%python_build
%if_with python3
pushd ../python3
find -type f -name '*.py' -exec 2to3 -w '{}' +
%python3_build
popd
%endif

%install
%python_install
%if_with python3
pushd ../python3
%python3_install
popd
%endif

%files
%doc *.txt
%python_sitelibdir/*
%exclude %python_sitelibdir/*/tests

%files tests
%python_sitelibdir/*/tests

%if_with python3
%files -n python3-module-%oname
%doc *.txt
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/tests

%files -n python3-module-%oname-tests
%python3_sitelibdir/*/tests
%endif

%changelog
