%define oname Enable
Name: python-module-%oname
Version: 4.2.1
Release: alt1.git20130108
Summary: Drawing and interaction packages

Group: Development/Python
License: BSD and GPLv2
URL: http://code.enthought.com/projects/enable/
# https://github.com/enthought/enable.git
Source: %oname-%version.tar.gz
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

BuildRequires: python-devel, python-module-setuptools
BuildPreReq: libnumpy-devel gcc-c++ swig python-module-Pyrex
BuildPreReq: python-module-sphinx-devel python-module-Pygments
BuildPreReq: libGL-devel libX11-devel python-module-Cython
BuildPreReq: libGLU-devel

%add_python_req_skip macport mac_context

%description
The Enable project provides two related multi-platform packages for
drawing GUI objects. The Enable package is a multi-platform object
drawing library built on top of Kiva. The core of Enable is a
container/component model for drawing and event notification. Kiva is a
multi-platform DisplayPDF vector drawing engine that supports multiple
output backends, including Windows, GTK, and Macintosh native windowing
systems, a variety of raster image formats, PDF, and Postscript.

%package pickles
Summary: Pickles for Enable project
Group: Development/Python

%description pickles
The Enable project provides two related multi-platform packages for
drawing GUI objects. The Enable package is a multi-platform object
drawing library built on top of Kiva. The core of Enable is a
container/component model for drawing and event notification. Kiva is a
multi-platform DisplayPDF vector drawing engine that supports multiple
output backends, including Windows, GTK, and Macintosh native windowing
systems, a variety of raster image formats, PDF, and Postscript.

This package contains pickles for Enable project.

%package tests
Summary: Tests for Enable project
Group: Development/Python
Requires: %name = %version-%release

%description tests
The Enable project provides two related multi-platform packages for
drawing GUI objects. The Enable package is a multi-platform object
drawing library built on top of Kiva. The core of Enable is a
container/component model for drawing and event notification. Kiva is a
multi-platform DisplayPDF vector drawing engine that supports multiple
output backends, including Windows, GTK, and Macintosh native windowing
systems, a variety of raster image formats, PDF, and Postscript.

This package contains tests for Enable project.

%package doc
Summary: Documentation for Enable project
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name < %version-%release

%description doc
The Enable project provides two related multi-platform packages for
drawing GUI objects. The Enable package is a multi-platform object
drawing library built on top of Kiva. The core of Enable is a
container/component model for drawing and event notification. Kiva is a
multi-platform DisplayPDF vector drawing engine that supports multiple
output backends, including Windows, GTK, and Macintosh native windowing
systems, a variety of raster image formats, PDF, and Postscript.

This package contains development documentation for Enable project.

%prep
%setup

%prepare_sphinx .

%build
%add_optflags -fno-strict-aliasing
%python_build_debug

%generate_pickles docs/source docs/source %oname
sphinx-build -E -a -b html -c docs/source -d doctrees docs/source html

%install
%python_install

rm -fR %buildroot%python_sitelibdir/enthought/kiva/mac
rm -f $(find %buildroot%python_sitelibdir -name '*mac*.py*')

install -d %buildroot%python_sitelibdir/enable
cp -fR pickle %buildroot%python_sitelibdir/enable/

%files
%doc *.txt
%python_sitelibdir/*
%exclude %python_sitelibdir/*/tests
%exclude %python_sitelibdir/*/*/tests
%exclude %python_sitelibdir/*/*/*/tests
%exclude %python_sitelibdir/enable/pickle

%files pickles
%dir %python_sitelibdir/enable
%python_sitelibdir/enable/pickle

%files tests
%python_sitelibdir/*/tests
%python_sitelibdir/*/*/tests
%python_sitelibdir/*/*/*/tests

%files doc
%doc docs/kiva docs/*.txt examples html

%changelog
