%define version 1.5.1
%define release alt1.hg20120916
%define oname PasteDeploy

%def_with python3

%setup_python_module %oname

Name: %packagename
Version:%version
Release: alt1.hg20120916.1
Serial: 1

Summary: Load, configure, and compose WSGI applications and servers

License: MIT/X11
Group: Development/Python
BuildArch: noarch
Url: http://pythonpaste.org
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# hg clone http://bitbucket.org/ianb/pastedeploy
Source: %modulename-%version.tar

Conflicts: python-module.paste.deploy
Obsoletes: python-module.paste.deploy
%py_provides %oname

BuildRequires: python-module-setuptools
BuildPreReq: python-module-sphinx python-module-Pygments
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-distribute
BuildPreReq: python3-module-sphinx python3-module-Pygments
%endif

%description
This tool provides code to load WSGI applications and servers from
URIs; these URIs can refer to Python Eggs for INI-style configuration
files. Paste Script provides commands to serve applications based on
this configuration file.

%if_with python3
%package -n python3-module-%oname
Summary: Load, configure, and compose WSGI applications and servers (Python 3)
Group: Development/Python3
%py3_provides %oname

%description -n python3-module-%oname
This tool provides code to load WSGI applications and servers from
URIs; these URIs can refer to Python Eggs for INI-style configuration
files. Paste Script provides commands to serve applications based on
this configuration file.
%endif

%prep
%setup -n %modulename-%version
%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%build
%python_build
%if_with python3
pushd ../python3
%python3_build
popd
%endif

./regen-docs

%install
%python_install
%if_with python3
pushd ../python3
%python3_install
popd
%endif

%files
%doc docs/_build/*
%python_sitelibdir/paste/deploy
%python_sitelibdir/%modulename-*
#exclude %python_sitelibdir/tests

%if_with python3
%files -n python3-module-%oname
%python3_sitelibdir/paste/deploy
%python3_sitelibdir/%modulename-*
%endif

%changelog
