%define oname PyQt4

%def_with python3

Name: python-module-%oname
Version: 4.10.3
Release: alt1.M70P.1
Summary: Python bindings for Qt.
License: GPL
Group: Development/Python

%setup_python_module %oname

Source0: PyQt-x11-gpl.tar
URL: http://www.riverbankcomputing.co.uk/software/pyqt
Packager: Python Development Team <python@packages.altlinux.org>

BuildPreReq: %py_package_dependencies sip-devel >= 4.8.1
BuildPreReq: %py_package_dependencies dbus-devel

%add_python_req_skip Compiler

BuildRequires: gcc-c++ libqt4-devel lout
BuildPreReq: python-module-qscintilla2-qt4-devel libqscintilla2-qt4-devel
BuildRequires: python-module-sip-devel python-devel
BuildPreReq: python-module-dbus-devel

%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-sip-devel
BuildPreReq: python3-module-dbus-devel
#BuildPreReq: python3-module-qscintilla2-qt4-devel
BuildPreReq: python3-module-sip-devel
%endif

%description
Python bindings for the Qt C++ class library.  Also includes a PyQt4 backend
code generator for Qt Designer.

%if_with python3
%package -n python3-module-%oname
Summary: Python 3 bindings for Qt
Group: Development/Python3
%add_python3_req_skip Compiler

%description -n python3-module-%oname
Python bindings for the Qt C++ class library.  Also includes a PyQt4 backend
code generator for Qt Designer.

%package -n python3-module-%oname-devel
Requires: python3-module-%oname = %version-%release
Summary:  Sip files for %name (Python 3)
BuildArch: noarch
Group: Development/Python3
%py3_provides %oname-devel

%description -n python3-module-%oname-devel
Sip files for PyQt to build extension
%endif

%package devel
Requires: %name = %version-%release
Summary:  Sip files for %name
BuildArch: noarch
Group: Development/Python
%py_package_provides %modulename-devel = %version-%release

%description devel
Sip files for PyQt to build extension

%package examples
Summary: PyQt4 examples
Group: Development/Python
BuildArch: noarch
Requires: %name
%py_package_provides %modulename-examples = %version-%release

%description examples
This package contains PyQt4 examples

%package doc
Summary: PyQt4 docs
Group: Development/Python
BuildArch: noarch
Requires: %name
%py_package_provides %modulename-examples = %version-%release

%description doc
This package contains PyQt4 docs

%prep
%setup -n PyQt-x11-gpl
subst 's|/lib/libpython|/%_lib/libpython|g' configure.py
subst 's|/lib" |/%_lib" |g' configure.py
subst 's|#include <QTextStream>|#include <QTextStream>\n#define QT_SHARED\n|g' \
	configure.py
find . -type f -name \*.pro -o -name '*.pro-in' |while read f; do
cat >> $f << 'E_O_F'
QMAKE_CFLAGS += %optflags %optflags_shared
QMAKE_CXXFLAGS += %optflags %optflags_shared
E_O_F
done

%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%build
export QT4DIR=%_qt4dir
%add_optflags -I$PWD/qpy/QtGui

echo 'yes' | python configure.py \
	--debug \
	--verbose \
	-q %_qt4dir/bin/qmake \
	-d %python_sitelibdir \
	-p %_qt4dir/plugins \
	-a --confirm-license \
	--qsci-api \
	--enable=designer-plugin \
	CFLAGS+="%optflags" CXXFLAGS+="%optflags"
for i in $(find ./ -name Makefile); do
	sed -i 's|-Wl,-rpath,|-I|g' $i
done
%make_build

%if_with python3
pushd ../python3
echo 'yes' | python3 configure.py \
	--debug \
	--verbose \
	-q %_qt4dir/bin/qmake \
	-d %python3_sitelibdir \
	-p %_qt4dir/plugins \
	-a --confirm-license \
	--qsci-api \
	--no-designer-plugin \
	--sipdir=%_datadir/sip3/%oname \
	--qsci-api-destdir=%_datadir/qt4/qsci3 \
	CFLAGS+="%optflags" CXXFLAGS+="%optflags"
for i in $(find ./ -name Makefile); do
	sed -i 's|lpython3\.2|lpython3.2mu|g' $i
done
for i in $(find ./ -name Makefile); do
	sed -i 's|-Wl,-rpath,|-I|g' $i
done
%make_build
popd
%endif

%install
%if_with python3
pushd ../python3
%makeinstall_std INSTALL_ROOT=%buildroot
popd
pushd %buildroot%_bindir
for i in $(ls); do
	mv $i py3_$i
done
popd
rm -fR %buildroot%python3_sitelibdir/%oname/uic/port_v2
%endif

%makeinstall_std INSTALL_ROOT=%buildroot
rm -rf %buildroot%python_sitelibdir/%oname/uic/port_v3

##wait ##
install -d %buildroot/usr/share/sip/PyQt4/Qsci \
	PyQt-x11-gpl/sip/QtGui
#bzip2 ChangeLog

%files
%_bindir/*
%if_with python3
%exclude %_bindir/py3_*
%endif
%python_sitelibdir/*
%_qt4dir/plugins/designer/libpyqt4.so

%files devel
%dir %_datadir/sip
%_datadir/sip/*
%dir %_datadir/qt4
%_datadir/qt4/qsci

%files doc
%doc doc/*
#doc NEWS README ChangeLog* THANKS
%doc NEWS README THANKS

%files examples
%doc examples

%if_with python3
%files -n python3-module-%oname
%_bindir/py3_*
%python3_sitelibdir/*

%files -n python3-module-%oname-devel
%dir %_datadir/sip3
%_datadir/sip3/*
%dir %_datadir/qt4
%_datadir/qt4/qsci3
%endif

%changelog
