%define oname SQLAlchemy

%def_with python3

Name: python-module-%oname
Version: 0.7.10
Release: alt1.1

Summary: Python SQL toolkit and Object Relational Mapper
License: MIT
Group: Development/Python
Url: http://www.sqlalchemy.org/

Source: SQLAlchemy-%version.tar
Patch0: SQLAlchemy-%version-alt-allinone.patch
%py_provides SQLAlchemy

#BuildArch: noarch
BuildPreReq: python-devel python-module-setuptools
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-distribute
BuildPreReq: python-tools-2to3
%endif

%description
SQLAlchemy is the Python SQL toolkit and Object Relational Mapper that gives
application developers the full power and flexibility of SQL.

It provides a full suite of well known enterprise-level persistence patterns,
designed for efficient and high-performing database access, adapted into a
simple and Pythonic domain language.

%if_with python3
%package -n python3-module-%oname
Summary: Python 3 SQL toolkit and Object Relational Mapper
Group: Development/Python3
BuildArch: noarch
%py3_provides SQLAlchemy

%description -n python3-module-%oname
SQLAlchemy is the Python SQL toolkit and Object Relational Mapper that gives
application developers the full power and flexibility of SQL.

It provides a full suite of well known enterprise-level persistence patterns,
designed for efficient and high-performing database access, adapted into a
simple and Pythonic domain language.

%package -n python3-module-%oname-tests
Summary: Tests for SQLAlchemy (Python 3)
Group: Development/Python3
BuildArch: noarch
Requires: python3-module-%oname = %version-%release

%description -n python3-module-%oname-tests
SQLAlchemy is the Python SQL toolkit and Object Relational Mapper that gives
application developers the full power and flexibility of SQL.

It provides a full suite of well known enterprise-level persistence patterns,
designed for efficient and high-performing database access, adapted into a
simple and Pythonic domain language.

This package contains tests for SQLAlchemy.
%endif

%package tests
Summary: Tests for SQLAlchemy
Group: Development/Python
#BuildArch: noarch
Requires: %name = %version-%release

%description tests
SQLAlchemy is the Python SQL toolkit and Object Relational Mapper that gives
application developers the full power and flexibility of SQL.

It provides a full suite of well known enterprise-level persistence patterns,
designed for efficient and high-performing database access, adapted into a
simple and Pythonic domain language.

This package contains tests for SQLAlchemy.

%prep
%setup -n SQLAlchemy-%version
%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%build
CFLAGS="%optflags" python setup.py install --optimize=2 --root=buildroot \
	--record INSTALLED_FILES

%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
mkdir -p %buildroot
cp -r buildroot/* %buildroot/

%if_with python3
pushd ../python3
%python3_install
popd
%endif

%files -f INSTALLED_FILES
#exclude %python_sitelibdir/*/test

#files tests
#python_sitelibdir/*/test

%if_with python3
%files -n python3-module-%oname
%python3_sitelibdir_noarch/*
#exclude %python3_sitelibdir_noarch/*/test

#files -n python3-module-%oname-tests
#python3_sitelibdir_noarch/*/test
%endif

%changelog
