%define version 1.1.3
%define release alt1
%setup_python_module TurboGears

Name: %packagename
Version: 1.1.3
Release: alt1

Summary: Back-to-front web development in Python

License: MIT/X11
Group: Development/Python
BuildArch: noarch
Url: http://www.turbogears.org
Packager: Denis Klimov <zver@altlinux.org>

Source: http://files.turbogears.org/eggs/%modulename-%version.tar

BuildPreReq: python-module-setuptools

%py_requires turbokid turbocheetah paste.script

# has no pythonX.Y() provides
Requires: python-module-decoratortools
Requires: python-module-PasteDeploy

# TurboGears needs old CherryPy
Requires: python-module-cherrypy2

%description
TurboGears brings together four major pieces to create an
easy to install, easy to use web megaframework. It covers
everything from front end (MochiKit JavaScript for the browser,
Kid for templates in Python) to the controllers (CherryPy) to
the back end (SQLObject).

The TurboGears project is focused on providing documentation
and integration with these tools without losing touch
with the communities that already exist around those tools.

TurboGears is easy to use for a wide range of web applications.


%prep
%setup -n %modulename-%version
# fix for TurboJson
%__subst "s|, < 1.2||g" setup.py

%build
%python_build

%install
%python_install

%files
%doc README.txt
%_bindir/tg-admin
%python_sitelibdir/turbogears
%python_sitelibdir/TurboGears*.egg-info

%changelog
