%define oname babel

%def_with python3

Name: python-module-%oname
Version: 0.9.6
Release: alt1.1

Summary: a collection of tools for internationalizing Python applications
License: BSD
Group: Development/Python

Url: http://babel.edgewall.org

Source: %name-%version.tar
Source1: CLDR.tar
Patch: %name-%version-%release.patch

Packager: Andrey Rahmatullin <wrar@altlinux.org>

BuildArch: noarch
BuildPreReq: python-module-setuptools 
%{?!_without_check:%{?!_disable_check:BuildRequires: %py_dependencies setuptools.command.test pytz}}

%setup_python_module babel
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-distribute
BuildPreReq: python3-module-pytz python-tools-2to3
%endif
%py_requires pytz

%description
Babel is an integrated collection of utilities that assist in
internationalizing and localizing Python applications, with an emphasis
on web-based applications.
The functionality Babel provides for internationalization (I18n) and
localization (L10N) can be separated into two different aspects:
  * tools to build and work with gettext message catalogs, and
  * a Python interface to the CLDR (Common Locale Data Repository),
    providing access to various locale display names, localized number
    and date formatting, etc.

%if_with python3
%package -n python3-module-%oname
Summary: a collection of tools for internationalizing Python 3 applications
Group: Development/Python3
%py3_requires pytz

%description -n python3-module-%oname
Babel is an integrated collection of utilities that assist in
internationalizing and localizing Python applications, with an emphasis
on web-based applications.
The functionality Babel provides for internationalization (I18n) and
localization (L10N) can be separated into two different aspects:
  * tools to build and work with gettext message catalogs, and
  * a Python interface to the CLDR (Common Locale Data Repository),
    providing access to various locale display names, localized number
    and date formatting, etc.
%endif

%prep
%setup -a1
%patch -p1
mkdir babel/localedata
%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%build
python scripts/import_cldr.py CLDR/
%python_build
%if_with python3
pushd ../python3
python scripts/import_cldr.py CLDR/
find -type f -name '*.py' -exec sed -i 's|%_bindir/env python|%_bindir/python3|' -- '{}' +
find -type f -name '*.py' -exec 2to3 -w '{}' +
sed -i \
	's|from UserDict import DictMixin|from collections import MutableMapping as DictMixin|' \
	babel/localedata.py
%python3_build build_ext
popd
%endif

%install
%if_with python3
pushd ../python3
%python3_install
popd
mv %buildroot%_bindir/pybabel %buildroot%_bindir/pybabel3
%endif
%python_install

%check
python setup.py test

%files
%_bindir/pybabel
%python_sitelibdir/babel/
%python_sitelibdir/*.egg-info
%doc ChangeLog doc

%if_with python3
%files -n python3-module-%oname
%doc ChangeLog doc
%_bindir/pybabel3
%python3_sitelibdir/babel/
%python3_sitelibdir/*.egg-info
%endif

%changelog
