%define oname beaker

%def_with python3

Name: python-module-%oname
Version: 1.6.4
Release: alt1.1
Summary: WSGI middleware layer to provide sessions

Group:  Development/Python
License: BSD
URL: http://pypi.python.org/pypi/Beaker
Source0: http://pypi.python.org/packages/source/B/Beaker/%{name}-%{version}.tar.gz
BuildPreReq: python-devel python-module-setuptools rpm-build-python
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-distribute
%endif

BuildArch: noarch

%add_python_req_skip jarray javax

%description
Beaker is a caching library that includes Session and Cache objects built on
Myghty's Container API used in MyghtyUtils. WSGI middleware is also included to
manage Session objects and signed cookies.

%if_with python3
%package -n python3-module-%oname
Summary: WSGI middleware layer to provide sessions (Python 3)
Group: Development/Python3
%add_python3_req_skip jarray javax builtins nss

%description -n python3-module-%oname
Beaker is a caching library that includes Session and Cache objects built on
Myghty's Container API used in MyghtyUtils. WSGI middleware is also included to
manage Session objects and signed cookies.
%endif

%prep
%setup
%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif


%build
%python_build
%if_with python3
pushd ../python3
sed -i 's|%_bindir/python|%_bindir/python3|' beaker/crypto/pbkdf2.py
sed -i '2d' beaker/crypto/pbkdf2.py
%python3_build
popd
%endif


%install
%python_install
%if_with python3
pushd ../python3
%python3_install
popd
%endif

%files
%doc LICENSE CHANGELOG
%python_sitelibdir/beaker/
%python_sitelibdir/Beaker*


%if_with python3
%files -n python3-module-%oname
%doc LICENSE CHANGELOG
%python3_sitelibdir/beaker/
%python3_sitelibdir/Beaker*
%endif

%changelog
