%define oname coverage

%def_with python3

Name: python-module-%oname
Version: 3.6.1
Release: alt2.a0.hg20130202
Summary: A tool for measuring code coverage of Python programs
License: BSD
Group: Development/Python
Url: http://nedbatchelder.com/code/coverage/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# hg clone http://bitbucket.org/ned/coveragepy
Source: %oname-%version.tar.gz

BuildRequires(pre): rpm-build-python
BuildPreReq: python-devel python-module-sphinx python-module-Pygments

%description
Coverage.py is a tool for measuring code coverage of Python programs. It
monitors your program, noting which parts of the code have been
executed, then analyzes the source to identify code that could have been
executed but was not.

Coverage measurement is typically used to gauge the effectiveness of
tests. It can show which parts of your product code are being exercised
by tests, and which are not.

%package doc
Summary: Documentation for Coverage python module
Group: Development/Documentation
BuildArch: noarch

%description doc
Coverage.py is a tool for measuring code coverage of Python programs. It
monitors your program, noting which parts of the code have been
executed, then analyzes the source to identify code that could have been
executed but was not.

This package contains documentation for Coverage.py.

%package pickles
Summary: Pickles for Coverage python module
Group: Development/Python

%description pickles
Coverage.py is a tool for measuring code coverage of Python programs. It
monitors your program, noting which parts of the code have been
executed, then analyzes the source to identify code that could have been
executed but was not.

This package contains pickles for Coverage.py.

%if_with python3
%package -n python3-module-%oname
Summary: A tool for measuring code coverage of Python3 programs
Group: Development/Python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-distribute

%description -n python3-module-%oname
Coverage.py is a tool for measuring code coverage of Python programs. It
monitors your program, noting which parts of the code have been
executed, then analyzes the source to identify code that could have been
executed but was not.

Coverage measurement is typically used to gauge the effectiveness of
tests. It can show which parts of your product code are being exercised
by tests, and which are not.
%endif

%prep
%setup
%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%build
%python_build_debug

export PYTHONPATH=$PWD
%make_build dochtml
%make_build pickle

%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%if_with python3
pushd ../python3
%python3_install
popd
mv %buildroot%_bindir/coverage %buildroot%_bindir/coverage3
%endif

%python_install

install -d %buildroot%python_sitelibdir/%oname/lab
install -p -m644 lab/* %buildroot%python_sitelibdir/%oname/lab

install -d %buildroot%_docdir/%name
cp -fR doc/_build/html/* %buildroot%_docdir/%name/
cp -fR doc/_build/pickle %buildroot%python_sitelibdir/%oname/

%files
%doc CHANGES.txt README.txt TODO.txt
%python_sitelibdir/*
%exclude %python_sitelibdir/%oname/pickle
%_bindir/*
%exclude %_bindir/coverage3
%exclude %_bindir/coverage-%_python3_version

%files doc
%_docdir/%name

%files pickles
%python_sitelibdir/%oname/pickle

%if_with python3
%files -n python3-module-%oname
%_bindir/coverage3
%_bindir/coverage-%_python3_version
%python3_sitelibdir/*.egg-info
%python3_sitelibdir/%oname
%endif

%changelog
