Version: 4.2.3
Release: alt4.svn20120223
%setup_python_module cx_Freeze
%define origname cx-freeze

%def_with python3

Name: python-module-%origname
Summary: Scripts and modules for freezing Python scripts into executables
License: PSF
URL: http://cx-freeze.sourceforge.net/
Provides: cx_Freeze
# https://cx-freeze.svn.sourceforge.net/svnroot/cx-freeze/trunk
Source: %origname-%version.tar.bz2
Group: Development/Python
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

BuildRequires(pre): rpm-build-python
BuildPreReq: python-devel
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python-tools-2to3
%endif
AutoReq: yes, nopython

%py_provides cx_Freeze
#py_requires elementtree.ElementTree datetime decimal cairo gio
#py_requires pangocairo_git pango_git atk_git
#py_requires numpy wx PyQt4 sip
#py_requires _strptime xml.etree.ElementTree os
#py_requires zlib

%description
cx_Freeze is a set of scripts and modules for freezing Python scripts into
executables in much the same way that py2exe and py2app do. It requires Python
2.3 or higher since it makes use of the zip import facility which was introduced
in that version.

There are three different ways to use cx_Freeze. The first is to use the
included freeze script which works well for simple scripts. The second is to
create a distutils setup script which can be used for more complicated
configuration or to retain the configuration for future use. The third method
involves working directly with the classes and modules used internally by
cx_Freeze and should be reserved for complicated scripts or extending or
embedding.

There are three different options for producing executables as well. The first
option is the only one that was available in earlier versions of cx_Freeze, that
is appending the zip file to the executable itself. The second option is
creating a private zip file with the same name as the executable but with the
extension .zip. The final option is the default which is to create a zip file
called library.zip and place all modules in this zip file. The final two options
are necessary when creating an RPM since the RPM builder automatically strips
executables.

%if_with python3
%package -n python3-module-%origname
Summary: Scripts and modules for freezing Python 3 scripts into executables
Group: Development/Python
AutoReq: yes, nopython
%py_provides cx_Freeze

%description -n python3-module-%origname
cx_Freeze is a set of scripts and modules for freezing Python scripts into
executables in much the same way that py2exe and py2app do. It requires Python
2.3 or higher since it makes use of the zip import facility which was introduced
in that version.

There are three different ways to use cx_Freeze. The first is to use the
included freeze script which works well for simple scripts. The second is to
create a distutils setup script which can be used for more complicated
configuration or to retain the configuration for future use. The third method
involves working directly with the classes and modules used internally by
cx_Freeze and should be reserved for complicated scripts or extending or
embedding.

There are three different options for producing executables as well. The first
option is the only one that was available in earlier versions of cx_Freeze, that
is appending the zip file to the executable itself. The second option is
creating a private zip file with the same name as the executable but with the
extension .zip. The final option is the default which is to create a zip file
called library.zip and place all modules in this zip file. The final two options
are necessary when creating an RPM since the RPM builder automatically strips
executables.
%endif

%package samples
Summary: Samples for cx_Freeze
Group: Development/Documentation
BuildArch: noarch

%description samples
cx_Freeze is a set of scripts and modules for freezing Python scripts into
executables in much the same way that py2exe and py2app do. It requires Python
2.3 or higher since it makes use of the zip import facility which was introduced
in that version.

This package contains samples for cx_Freeze.

%prep
%setup
%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%build
%python_build_debug
%if_with python3
pushd ../python3
sed -i 's|\(libname =.*\)|\1 + "%_python3_abiflags"|' setup.py
find -type f -name '*.py' -exec 2to3 -w '{}' +
%python3_build_debug
popd
%endif

%install
%if_with python3
pushd ../python3
%python3_install

for i in $(find %buildroot%python3_sitelibdir/cx_Freeze/ -type d)
do
	touch $i/__init__.py
done
popd
pushd %buildroot%_bindir
for i in $(ls); do
	mv $i py3_$i
done
popd
%endif

%python_install

for i in $(find %buildroot%python_sitelibdir/cx_Freeze/ -type d)
do
	touch $i/__init__.py
done

rm -f $(find %buildroot -name 'windist*')

%files
%doc *.txt doc/*.html
%_bindir/*
%if_with python3
%exclude %_bindir/py3_*
%endif
%python_sitelibdir/*
%exclude %python_sitelibdir/*/samples

%files samples
%doc samples

%if_with python3
%files -n python3-module-%origname
%doc *.txt doc/*.html
%_bindir/py3_*
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/samples
%endif

%changelog
