%define _name dbus-python
%def_disable check

Name: python-module-dbus
Version: 1.1.1
Release: alt4

Summary: Python bindings for D-BUS library
License: AFL/GPL
Group: Development/Python
Url: http://www.freedesktop.org/wiki/Software/DBusBindings

Source: dbus-python-%version.tar
#Source: http://dbus.freedesktop.org/releases/dbus-python/dbus-python-%version.tar.gz
Patch: dbus-python-1.1.1-1-alt-link.patch
Patch2: dbus-python-1.1.1-alt-usc4-impaired-python-hack2-around.patch

%setup_python_module dbus

Requires: dbus
Provides: %_name = %version-%release
Provides: %name-data = %version-%release
Obsoletes: %name-data < %version-%release

BuildRequires: libdbus-devel >= 1.6 libdbus-glib-devel
BuildRequires: python-devel python3-devel
BuildRequires: python-module-pygobject3
# for python3
BuildRequires: rpm-build-python3 python3-devel python3-module-pygobject3
%{?_enable_check:BuildRequires: /proc dbus-tools dbus-tools-gui glibc-i18ndata}

%description
D-Bus python bindings for use with python programs.

%package -n python3-module-dbus
Summary: Python3 bindings for D-BUS library
License: AFL/GPL
Group: Development/Python3
Requires: dbus

%description -n python3-module-dbus
D-Bus python bindings for use with python programs.

%package devel
Summary: Python bindings for D-BUS library (devel package)
Group: Development/Python
Requires: %name = %version-%release
%py_package_provides %modulename-devel = %version-%release
Provides: python3-module-dbus-devel = %version-%release

%description devel
D-Bus python bindings for use with python programs.
Development package.

%prep
%setup -n %_name-%version
%setup -D -c -n %_name-%version
mv %_name-%version py3build
%patch -p1
%patch2 -p1

%build
# Install python code into arch-specific dir for PyQt4 (ALT#23134)
export am_cv_python_pythondir=%python_sitelibdir

%autoreconf
%configure PYTHON=%__python
%make_build

pushd py3build
export am_cv_python_pythondir=%python3_sitelibdir
%autoreconf
%configure PYTHON=/usr/bin/python3 \
	PYTHON_LIBS="$(python3-config --libs)"
%make_build
popd

%install
for d in {.,py3build}; do
pushd $d
%makeinstall_std
popd
done

%if_enabled check
%check
%make check
%make check -C py3build
%endif

%files
%python_sitelibdir/*.so
%python_sitelibdir/dbus/
%doc AUTHORS COPYING NEWS

%files devel
%doc doc/*.txt
%_includedir/dbus-1.0/dbus/dbus-python.h
%_pkgconfigdir/dbus-python.pc

%exclude %python_sitelibdir/*.la

%files -n python3-module-dbus
%python3_sitelibdir/*.so
%python3_sitelibdir/dbus/

%exclude %python3_sitelibdir/*.la

%exclude %_docdir/dbus-python

%changelog
