# This spec is backported to ALTLinux p7 automatically by rpmbph script. Do not edit it.
#
%define version 1.4.5
%define release alt2
%define origname Django
%define pkgname django1.4
%setup_python_module django
%add_python_req_skip cx_Oracle
%add_findreq_skiplist %python_sitelibdir/%modulename/contrib/gis/db/backends/*/*

Name: python-module-%pkgname
Version: %version
Release: alt1.M70P.2

Summary: A high-level Python Web framework that encourages rapid development and clean, pragmatic design.

License: BSD
Group: Development/Python
URL: http://www.djangoproject.com/

BuildArch: noarch

Source0: %origname-%version.tar

Provides: Django = %version-%release
Conflicts: python-module-django1.0 python-module-django1.1
Conflicts: python-module-django1.2
Conflicts: python-module-django

BuildPreReq: %py_dependencies setuptools

# Automatically added by buildreq on Tue Jul 29 2008 (-ba)
BuildRequires: python-module-setuptools python-modules-email
BuildRequires: python-modules-encodings python-modules-sqlite3
BuildRequires: python-modules-xml
BuildRequires: python-modules-ctypes

%description
%summary

%package tests
Summary: Tests for Django
Group: Development/Python
BuildArch: noarch
Requires: %name = %version-%release

%description tests
%summary

This package contains tests for Django.

%package mod_python
Summary: mod_python support for Django.
Group: Development/Python
Requires: %name = %version-%release 
Requires: apache2-mod_python
Conflicts: python-module-django1.0-mod_python

%description mod_python
%summary

%package dbbackend-mysql
Summary: MySQLSQL support for Django.
Group: Development/Python
Requires: %name = %version-%release 
%py_requires MySQLdb
Conflicts: python-module-django1.0-dbbackend-mysql
Conflicts: python-module-django1.1-dbbackend-mysql

%description dbbackend-mysql
%summary

%package dbbackend-psycopg
Summary: PostgreSQL support for Django. (via psycopg)
Group: Development/Python
Requires: %name = %version-%release 
%py_requires psycopg
Conflicts: python-module-django1.0-dbbackend-psycopg
Conflicts: python-module-django1.1-dbbackend-psycopg

%description dbbackend-psycopg
%summary

%package dbbackend-psycopg2
Summary: PostgreSQL support for Django. (via psycopg2)
Group: Development/Python
Requires: %name = %version-%release 
%py_requires psycopg2
Conflicts: python-module-django1.0-dbbackend-psycopg2
Conflicts: python-module-django1.1-dbbackend-psycopg2

%description dbbackend-psycopg2
%summary

%package dbbackend-sqlite3
Summary: SQLite3 support for Django.
Group: Development/Python
Requires: %name = %version-%release 
%py_requires sqlite3
Conflicts: python-module-django1.0-dbbackend-sqlite3
Conflicts: python-module-django1.1-dbbackend-sqlite3

%description dbbackend-sqlite3
%summary

%package doc
Summary: Django documentation
Group: Development/Python

%description doc
%summary

%prep
%setup -n %origname-%version

%build
%python_build

%install
mkdir -p %buildroot/%_sysconfdir/bash_completion.d

%python_install --record=INSTALLED_FILES
#sed -i -e '/\/test/d' INSTALLED_FILES

install -m 0755 extras/django_bash_completion %buildroot/%_sysconfdir/bash_completion.d/django.sh

# Run tests
#export PYTHONPATH="$PYTHONPATH:%buildroot/%python_sitelibdir/"
#cat >tests/settings.py << EOF
#DATABASE_ENGINE = 'sqlite3'
#DATABASE_NAME = 'demodb'
#ROOT_URLCONF=None 
#EOF
#tests/runtests.py --settings=settings --noinput -v 1
# End tests

%files -f INSTALLED_FILES
%exclude %python_sitelibdir/%modulename/core/handlers/modpython.py*
%exclude %python_sitelibdir/%modulename/contrib/auth/handlers/modpython.py*

%exclude %python_sitelibdir/%modulename/db/backends/mysql/
#exclude %python_sitelibdir/%modulename/db/backends/postgresql/
%exclude %python_sitelibdir/%modulename/db/backends/postgresql_psycopg2/
%exclude %python_sitelibdir/%modulename/db/backends/sqlite3/

%exclude %python_sitelibdir/%modulename/test
%exclude %python_sitelibdir/%modulename/*/*/test*.py*
%exclude %python_sitelibdir/%modulename/*/*/tests
%exclude %python_sitelibdir/%modulename/*/*/*/tests

%config %_sysconfdir/bash_completion.d/django.sh

%files tests
%python_sitelibdir/%modulename/test
%python_sitelibdir/%modulename/*/*/test*.py*
%python_sitelibdir/%modulename/*/*/tests
%python_sitelibdir/%modulename/*/*/*/tests

%files doc
%doc docs

%files mod_python
%python_sitelibdir/%modulename/core/handlers/modpython.py*
%python_sitelibdir/%modulename/contrib/auth/handlers/modpython.py*

%files dbbackend-mysql
%python_sitelibdir/%modulename/db/backends/mysql/

#files dbbackend-psycopg
#python_sitelibdir/%modulename/db/backends/postgresql/

%files dbbackend-psycopg2
%python_sitelibdir/%modulename/db/backends/postgresql_psycopg2/

%files dbbackend-sqlite3
%python_sitelibdir/%modulename/db/backends/sqlite3/

%changelog
