%define oname egenix-mx-base

%def_without python3

Name: python-module-%oname
Version: 3.2.4
Release: alt1

Summary: eGenix.com mx Base Distribution
License: eGenix.com Public License Agreement
Group: Development/Python

Packager: Python Development Team <python@packages.altlinux.org>

Source: %name-%version.tar

Url: http://www.egenix.com/products/python/mxBase/

Obsoletes: egenix-mx-base < 2.0.3-alt8
Provides: egenix-mx-base  = %version-%release

%setup_python_module %oname
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-distribute
BuildPreReq: python-tools-2to3
%endif

%description
The eGenix mx Extension Series are a collection of Python extensions
written in ANSI C and Python which provide a large spectrum of useful
additions to everyday Python programming.

The Base Distribution includes the Open Source subpackages of the
series and is needed by all other add-on packages of the series:

  mxDateTime - Date/Time Library for Python
  mxTextTools - Fast Text Parsing and Processing Tools for Python
  mxProxy - Object Access Control for Python
  mxBeeBase - On-disk B+Tree Based Database Kit for Python
  mxURL - Flexible URL Data-Type for Python
  mxUID - Fast Universal Identifiers for Python
  mxStack - Fast and Memory-Efficient Stack Type for Python
  mxQueue - Fast and Memory-Efficient Queue Type for Python
  mxTools - Fast Everyday Helpers for Python

%if_with python3
%package -n python3-module-%oname
Summary: eGenix.com mx Base Distribution (Python 3)
Group: Development/Python3

%description -n python3-module-%oname
The eGenix mx Extension Series are a collection of Python 3 extensions
written in ANSI C and Python 3 which provide a large spectrum of useful
additions to everyday Python 3 programming.

The Base Distribution includes the Open Source subpackages of the
series and is needed by all other add-on packages of the series:

  mxDateTime - Date/Time Library for Python 3
  mxTextTools - Fast Text Parsing and Processing Tools for Python 3
  mxProxy - Object Access Control for Python 3
  mxBeeBase - On-disk B+Tree Based Database Kit for Python 3
  mxURL - Flexible URL Data-Type for Python 3
  mxUID - Fast Universal Identifiers for Python 3
  mxStack - Fast and Memory-Efficient Stack Type for Python 3
  mxQueue - Fast and Memory-Efficient Queue Type for Python 3
  mxTools - Fast Everyday Helpers for Python 3
%endif

%prep
%setup
%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%build
%if_with python3
pushd ../python3
for i in $(find ./ -name '*.py'); do
	2to3 -w $i
done
%python3_build
popd
%endif
%python_build_debug

%install
%python_install

find %buildroot/%python_sitelibdir/mx/ -type d -name Doc -print0 | xargs -r0 rm -rf --
find %buildroot/%python_sitelibdir/mx/ -type f -name 'test*.py' -delete
rm -f %buildroot/%python_sitelibdir/mx/{BeeBase/showBeeDict.py,Misc/FileLock.py,Proxy/mxProxy/weakreftest.py,Stack/stackbench.py,Queue/queuebench.py}

%if_with python3
pushd ../python3
%python3_install
popd
find %buildroot/%python3_sitelibdir/mx/ -type d -name Doc -print0 | xargs -r0 rm -rf --
find %buildroot/%python3_sitelibdir/mx/ -type f -name 'test*.py' -delete
rm -f %buildroot/%python3_sitelibdir/mx/{BeeBase/showBeeDict.py,Misc/FileLock.py,Proxy/mxProxy/weakreftest.py,Stack/stackbench.py,Queue/queuebench.py}
%endif

%files
%python_sitelibdir/mx/
%python_sitelibdir/*.egg-info
%doc COPYRIGHT LICENSE README

%if_with python3
%files -n python3-module-%oname
%doc COPYRIGHT LICENSE README
%python3_sitelibdir/*
%endif

%changelog
