%define oname envisage
Name:           python-module-%oname
Version:        4.2.1
Release:        alt1.git20130108
Summary:        Extensible Application Framework

Group:          Development/Python
License:        BSD
URL:            http://code.enthought.com/projects/envisage/
# https://github.com/enthought/envisage.git
Source:        %oname-%version.tar.gz
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

BuildArch:      noarch
BuildRequires:  python-module-setuptools, python-devel
BuildPreReq: python-module-setupdocs python-module-sphinx-devel
Requires:       python-module-apptools
Provides: python-module-EnvisageCore = %version-%release
Obsoletes: python-module-EnvisageCore < %version-%release
Provides: python-module-EnvisagePlugins = %version-%release
Obsoletes: python-module-EnvisagePlugins < %version-%release

%description
Envisage is a Python-based framework for building extensible
applications, that is, applications whose functionality can be
extended by adding "plug-ins". Envisage provides a standard mechanism
for features to be added to an application, whether by the original
developer or by someone else.

%package docs
Summary: Documentation for Extensible Application Framework
Group: Development/Documentation
BuildArch: noarch

%description docs
Envisage is a Python-based framework for building extensible
applications, that is, applications whose functionality can be
extended by adding "plug-ins". Envisage provides a standard mechanism
for features to be added to an application, whether by the original
developer or by someone else.

This package contains development documentation for Envisage.

%package pickles
Summary: Pickles for Extensible Application Framework
Group: Development/Python

%description pickles
Envisage is a Python-based framework for building extensible
applications, that is, applications whose functionality can be
extended by adding "plug-ins". Envisage provides a standard mechanism
for features to be added to an application, whether by the original
developer or by someone else.

This package contains pickles for Envisage.

%package tests
Summary: Tests for Extensible Application Framework
Group: Development/Python
Requires: %name = %version-%release

%description tests
Envisage is a Python-based framework for building extensible
applications, that is, applications whose functionality can be
extended by adding "plug-ins". Envisage provides a standard mechanism
for features to be added to an application, whether by the original
developer or by someone else.

This package contains tests for Envisage.

%prep
%setup

%prepare_sphinx .

%build
%python_build

%generate_pickles docs/source docs/source %oname
sphinx-build -E -a -b html -c docs/source -d doctrees docs/source html

%install
%python_install

cp -fR pickle %buildroot%python_sitelibdir/%oname/

%files
%doc *.txt
%python_sitelibdir/*
%exclude %python_sitelibdir/*/tests
%exclude %python_sitelibdir/*/*/tests
%exclude %python_sitelibdir/*/*/*/*/tests
%exclude %python_sitelibdir/%oname/pickle

%files tests
%python_sitelibdir/*/tests
%python_sitelibdir/*/*/tests
%python_sitelibdir/*/*/*/*/tests

%files docs
%doc examples html

%files pickles
%dir %python_sitelibdir/%oname
%python_sitelibdir/%oname/pickle

%changelog
