%define oname fipy
Name: python-module-%oname
Version: 3.0
Release: alt1
Summary: Partial differential equation (PDE) solver
License: Public
Group: Development/Python
Url: http://www.ctcms.nist.gov/fipy
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

Source: FiPy-%version.tar.gz
Source1: %oname-%version.pdf
#Source2: reference-2.0.2.pdf
BuildArch: noarch

BuildPreReq: python-devel libnumpy-devel python-module-pysparse
BuildPreReq: python-module-setuptools-tests
%setup_python_module %oname

Requires: python-module-gnuplot
%py_requires gist

%description
FiPy is an object oriented, partial differential equation (PDE) solver,
written in Python, based on a standard finite volume (FV) approach

The solution of coupled sets of PDEs is ubiquitous to the numerical
simulation of science problems.  Numerous PDE solvers exist, using a
variety of languages and numerical approaches. Many are proprietary,
expensive and difficult to customize.  As a result, scientists spend
considerable resources repeatedly developing limited tools for
specific problems.  Our approach, combining the FV method and Python_,
provides a tool that is extensible, powerful and freely available. A
significant advantage to Python_ is the existing suite of tools for
array calculations, sparse matrices and data rendering.

%package tests
Summary: Tests for FiPy
Group: Development/Python
Requires: %name = %version-%release

%description tests
FiPy is an object oriented, partial differential equation (PDE) solver,
written in Python, based on a standard finite volume (FV) approach

This package contains tests for FiPy.

%package examples
Summary: Examples for FiPy
Group: Development/Documentation
Requires: %name = %version-%release

%description examples
FiPy is an object oriented, partial differential equation (PDE) solver,
written in Python, based on a standard finite volume (FV) approach

This package contains examples for FiPy.

%package doc
Summary: Documentation for FiPy
Group: Development/Documentation
BuildArch: noarch

%description doc
FiPy is an object oriented, partial differential equation (PDE) solver,
written in Python, based on a standard finite volume (FV) approach

This package contains documentation for FiPy.

%prep
%setup
#sed -i 's|with|with_|' \
#	fipy/viewers/gnuplotViewer/gnuplot1DViewer.py

install -p -m644 %SOURCE1 .

%build
%python_build

%install
%python_install

#install -d %buildroot%python_sitelibdir/%oname/utils
#install -p -m644 utils/* \
#	%buildroot%python_sitelibdir/%oname/utils
cp -fR examples %buildroot%python_sitelibdir/%oname/

install -d %buildroot%_docdir/%name
cp -fR documentation/* %buildroot%_docdir/%name/

%files
%python_sitelibdir/*
%exclude %python_sitelibdir/*/tests
%exclude %python_sitelibdir/*/examples

%files tests
%python_sitelibdir/*/tests

%files examples
%python_sitelibdir/*/examples

%files doc
%doc DISCLAIMER.txt LICENSE.txt README.txt *.pdf
%_docdir/%name

%changelog
