%define oname gevent

%def_with python3

Name: python-module-%oname
Version: 1.0
Release: alt4.git20130221

Summary: Python network library that uses greenlet and libevent for easy and scalable concurrency

Group: Development/Python
License: MIT
Url: http://pypi.python.org/pypi/%oname

%py_requires greenlet

# https://github.com/sitesupport/gevent.git
Source: %oname-%version.tar

# Automatically added by buildreq on Wed Feb 03 2010
BuildRequires: libevent1.4-devel python-devel python-modules-ctypes

BuildPreReq: python-module-sphinx-devel python-module-greenlet
BuildPreReq: python-module-OpenSSL python-module-Cython unifdef

%setup_python_module %oname
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-greenlet
BuildPreReq: python3-module-distribute python3-module-Cython
BuildPreReq: python3-module-OpenSSL python-tools-2to3
%endif

%description
gevent is a coroutine-based Python networking library that uses greenlet
to provide a high-level synchronous API on top of libevent event loop.

Features include:
* convenient API around greenlets
* familiar synchronization primitives (gevent.event, gevent.queue)
* socket module that cooperates
* WSGI server on top of libevent-http
* DNS requests done through libevent-dns
* monkey patching utility to get pure Python modules to cooperate

%if_with python3
%package -n python3-module-%oname
Summary: Python 3 network library that uses greenlet and libevent for easy and scalable concurrency
Group: Development/Python3
%py3_requires greenlet

%description -n python3-module-%oname
gevent is a coroutine-based Python networking library that uses greenlet
to provide a high-level synchronous API on top of libevent event loop.

Features include:
* convenient API around greenlets
* familiar synchronization primitives (gevent.event, gevent.queue)
* socket module that cooperates
* WSGI server on top of libevent-http
* DNS requests done through libevent-dns
* monkey patching utility to get pure Python modules to cooperate
%endif

%package doc
Summary: Documentation for gevent
Group: Development/Documentation
BuildArch: noarch

%description doc
gevent is a coroutine-based Python networking library that uses greenlet
to provide a high-level synchronous API on top of libevent event loop.

This package contains documentation and examples for gevent.

%package pickles
Summary: Pickles for gevent
Group: Development/Documentation

%description pickles
gevent is a coroutine-based Python networking library that uses greenlet
to provide a high-level synchronous API on top of libevent event loop.

This package contains pickles for gevent.

%prep
%setup
%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%prepare_sphinx doc

%build
%add_optflags -fno-strict-aliasing
%python_build_debug
%if_with python3
pushd ../python3
export CYTHON=cython3
sed -i 's|import mimetools|import email.message|' gevent/pywsgi.py
sed -i 's|mimetools.Message|email.message.Message|' gevent/pywsgi.py
sed -i 's|basestring|str|g' gevent/ares.pyx
%python3_build_debug || \
	(%make clean; %python3_build_debug || \
		(%make clean; %python3_build_debug ))
popd
%endif

%install
%python_install
%if_with python3
pushd ../python3
%python3_install
find %buildroot%python3_sitelibdir -type f -name '*.py' -exec 2to3 -w -n '{}' +
popd
%endif

#doc

export PYTHONPATH=%buildroot%python_sitelibdir
pushd doc
%make pickle
%make html

cp -fR _build/pickle %buildroot%python_sitelibdir/%oname/
popd

%files
%doc AUTHORS LICENSE* TODO *.rst
%python_sitelibdir/*
%exclude %python_sitelibdir/%oname/pickle

%files doc
%doc doc/_build/html
%doc examples

%files pickles
%python_sitelibdir/%oname/pickle

%if_with python3
%files -n python3-module-%oname
%doc AUTHORS LICENSE* TODO *.rst
%python3_sitelibdir/*
%endif

%changelog
