%define module_name html5lib

%def_with python3

Name: python-module-%module_name
Version: 0.95
Release: alt4

Summary: Library for working with HTML5 documents

License: MIT
Group: Development/Python
BuildArch: noarch
Url: http://code.google.com/p/html5lib

Source: %module_name-%version.tar

BuildRequires: python-module-setuptools

%setup_python_module %module_name

%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-distribute
BuildPreReq: python-tools-2to3
%endif

%description
A ruby/python based HTML parser/tokenizer based on the WHATWG
HTML5 specification for maximum compatibility with major
desktop web browsers.

%package tests
Summary: Tests for html5lib
Group: Development/Python
Requires: %name = %version-%release

%description tests
A ruby/python based HTML parser/tokenizer based on the WHATWG
HTML5 specification for maximum compatibility with major
desktop web browsers.

This package contains tests for html5lib.

%if_with python3
%package -n python3-module-%module_name
Summary: Library for working with HTML5 documents (Python 3)
Group: Development/Python3

%description -n python3-module-%module_name
A ruby/python based HTML parser/tokenizer based on the WHATWG
HTML5 specification for maximum compatibility with major
desktop web browsers.

%package -n python3-module-%module_name-tests
Summary: Tests for html5lib (Python 3)
Group: Development/Python3
Requires: python3-module-%module_name = %version-%release

%description -n python3-module-%module_name-tests
A ruby/python based HTML parser/tokenizer based on the WHATWG
HTML5 specification for maximum compatibility with major
desktop web browsers.

This package contains tests for html5lib.
%endif

%prep
%setup -n %module_name-%version
%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%build
%python_build
%if_with python3
pushd ../python3
find -type f -name '*.py' -exec 2to3 -w '{}' +
%python3_build
popd
%endif

%install
%python_install --record=INSTALLED_FILES
%if_with python3
pushd ../python3
%python3_install
popd
%endif

%files -f INSTALLED_FILES
%doc README
%exclude %python_sitelibdir/*/tests

%files tests
%python_sitelibdir/*/tests

%if_with python3
%files -n python3-module-%module_name
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/tests

%files -n python3-module-%module_name-tests
%python3_sitelibdir/*/tests
%endif

%changelog
