%define oname jinja2

%def_with python3
%def_disable check

Name: python-module-%oname
Version: 2.9
Release: alt0.M70P.1.dev.git20150726

Summary: The new and improved version of a small but fast template engine
License: BSD
Group: Development/Python
Url: http://jinja.pocoo.org/2/

Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# https://github.com/mitsuhiko/jinja2.git
Source0: %name-%version.tar
#Patch: %name-%version-%release.patch

BuildArch: noarch

BuildPreReq: python-devel python-module-setuptools-tests
# for docs
BuildPreReq: python-module-sphinx python-module-Pygments
BuildPreReq: python-module-jinja2-tests python-module-markupsafe
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-setuptools-tests
BuildPreReq: python-tools-2to3
%endif

Requires: %name-tests = %version-%release

%description
Jinja2 is a template engine written in pure Python. It provides a Django
inspired non-XML syntax but supports inline expressions and an optional
sandboxed environment.

%if_with python3
%package -n python3-module-%oname
Summary: The new and improved version of a small but fast template engine (Python 3)
Group: Development/Python3
Requires: python3-module-%oname-tests = %version-%release

%description -n python3-module-%oname
Jinja2 is a template engine written in pure Python. It provides a Django
inspired non-XML syntax but supports inline expressions and an optional
sandboxed environment.

%package -n python3-module-%oname-tests
Summary: Tests for Jinja2 (Python 3)
Group: Development/Python3
Requires: python3-module-%oname = %version-%release

%description -n python3-module-%oname-tests
Jinja2 is a template engine written in pure Python. It provides a Django
inspired non-XML syntax but supports inline expressions and an optional
sandboxed environment.

This package contains tests for Jinja2.
%endif

%package tests
Summary: Tests for Jinja2
Group: Development/Python
Requires: %name = %version-%release

%description tests
Jinja2 is a template engine written in pure Python. It provides a Django
inspired non-XML syntax but supports inline expressions and an optional
sandboxed environment.

This package contains tests for Jinja2.

%package doc
Summary: Documentation for Jinja2
Group: Development/Documentation

%description doc
Jinja2 is a template engine written in pure Python. It provides a Django
inspired non-XML syntax but supports inline expressions and an optional
sandboxed environment.

This package contains HTML documentation for Jinja2.

%package pickles
Summary: Pickles for Jinja2
Group: Development/Python

%description pickles
Jinja2 is a template engine written in pure Python. It provides a Django
inspired non-XML syntax but supports inline expressions and an optional
sandboxed environment.

This package contains pickles for Jinja2.


%prep
%setup
%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%build
%python_build
%if_with python3
pushd ../python3
%python3_build
popd
%endif

%make_build -C docs html
%make_build -C docs pickle

%install
%python_install
# IronPython support
rm -f %buildroot%python_sitelibdir_noarch/jinja2/_ipysupport.py

%if_with python3
pushd ../python3
%python3_install
popd
rm -f %buildroot%python3_sitelibdir_noarch/jinja2/_ipysupport.py
%endif

cp -fR docs/_build/pickle %buildroot%python_sitelibdir_noarch/jinja2/

%check
make test

%files
%python_sitelibdir_noarch/jinja2/
%python_sitelibdir_noarch/*.egg-info
%exclude %python_sitelibdir_noarch/jinja2/tests.py*
#exclude %python_sitelibdir_noarch/jinja2/testsuite
%exclude %python_sitelibdir_noarch/jinja2/pickle
%doc AUTHORS CHANGES
%doc ext/

%files tests
%python_sitelibdir_noarch/jinja2/tests.py*
#python_sitelibdir_noarch/jinja2/testsuite

%files doc
%doc docs/_build/html/*

%files pickles
%dir %python_sitelibdir_noarch/jinja2
%python_sitelibdir_noarch/jinja2/pickle

%if_with python3
%files -n python3-module-%oname
%doc AUTHORS CHANGES
%python3_sitelibdir_noarch/jinja2/
%python3_sitelibdir_noarch/*.egg-info
%exclude %python3_sitelibdir_noarch/jinja2/tests.py*
%exclude %python3_sitelibdir_noarch/jinja2/*/tests.*
#exclude %python3_sitelibdir_noarch/jinja2/testsuite

%files -n python3-module-%oname-tests
%python3_sitelibdir_noarch/jinja2/tests.py*
%python3_sitelibdir_noarch/jinja2/*/tests.*
#python3_sitelibdir_noarch/jinja2/testsuite
%endif

%changelog
