%define oname python-ldap

Summary: LDAP client API for Python
Name: python-module-ldap
Version: 2.3.11
Release: alt2.1.1
Source0: %oname-%version.tar
License: Python-style license
Group: Development/Python
Url: http://python-ldap.sourceforge.net/

BuildPreReq: python-devel
BuildPreReq: rpm-build-python >= 0.8
BuildRequires: libldap-devel >= 2.3 libssl-devel
BuildPreReq: texlive-latex-recommended python-module-sphinx

Obsoletes: python-ldap
Packager: Python Development Team <python@packages.altlinux.org>

%description
python-ldap provides an object-oriented API to access LDAP
directory servers from Python programs. Mainly it wraps the
OpenLDAP 2.x libs for that purpose.

Additionally the package contains modules for other LDAP-related
stuff (e.g. processing LDIF, LDAPURLs, LDAPv3 sub-schema, etc.).

%package demos
Summary: Demos for python-ldap
Group: Development/Documentation
BuildArch: noarch
Requires: %name = %version-%release

%description demos
python-ldap provides an object-oriented API to access LDAP
directory servers from Python programs. Mainly it wraps the
OpenLDAP 2.x libs for that purpose.

Additionally the package contains modules for other LDAP-related
stuff (e.g. processing LDIF, LDAPURLs, LDAPv3 sub-schema, etc.).

This package contains demos for python-ldap.

%package tests
Summary: Tests for python-ldap
Group: Development/Python
BuildArch: noarch
Requires: %name = %version-%release

%description tests
python-ldap provides an object-oriented API to access LDAP
directory servers from Python programs. Mainly it wraps the
OpenLDAP 2.x libs for that purpose.

Additionally the package contains modules for other LDAP-related
stuff (e.g. processing LDIF, LDAPURLs, LDAPv3 sub-schema, etc.).

This package contains tests for python-ldap.

%package doc
Summary: Documentation for python-ldap
Group: Development/Documentation
BuildArch: noarch

%description doc
python-ldap provides an object-oriented API to access LDAP
directory servers from Python programs. Mainly it wraps the
OpenLDAP 2.x libs for that purpose.

Additionally the package contains modules for other LDAP-related
stuff (e.g. processing LDIF, LDAPURLs, LDAPv3 sub-schema, etc.).

This package contains documentation for python-ldap.

%package pickles
Summary: Pickles for python-ldap
Group: Development/Python

%description pickles
python-ldap provides an object-oriented API to access LDAP
directory servers from Python programs. Mainly it wraps the
OpenLDAP 2.x libs for that purpose.

Additionally the package contains modules for other LDAP-related
stuff (e.g. processing LDIF, LDAPURLs, LDAPv3 sub-schema, etc.).

This package contains pickles for python-ldap.

%prep
%setup -n %oname-%version

%build
env CFLAGS="$RPM_OPT_FLAGS" python setup.py build

%make -C Doc latex

%install
%python_install --optimize=2

cp -fR Doc/.build/pickle %buildroot%python_sitelibdir/ldap/

%files
%doc LICENCE CHANGES README TODO
%python_sitelibdir/*
%exclude %python_sitelibdir/ldap/pickle

%files demos
%doc Demo

%files tests
%doc Tests

%files doc
%doc Doc/.build/html Doc/.build/latex/*.pdf

%files pickles
%python_sitelibdir/ldap/pickle

%changelog
