%def_enable check
%def_with python3

%define oname logilab-common
Name: python-module-%oname
Version: 0.59.0
Release: alt2.hg20130215

Summary: Useful miscellaneous modules used by Logilab projects
License: LGPLv2.1+
Group: Development/Python

BuildArch: noarch

Url: http://www.logilab.org/project/logilab-common
Source: %name-%version.tar

Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

%py_requires mx.DateTime
%add_python_req_skip mercurial sphinx

%setup_python_module %oname

%{?!_without_check:%{?!_disable_check:BuildRequires: /proc %py_dependencies mx.DateTime unittest2}}
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-distribute
BuildPreReq: python-tools-2to3
%endif

%description
logilab-common is a collection of low-level Python packages and modules,
designed to ease:
  * handling command line options and configuration files
  * writing interactive command line tools
  * manipulation files and character strings
  * interfacing to OmniORB (removed by packager)
  * generating of SQL queries
  * running unit tests
  * manipulating tree structures
  * accessing RDBMS (currently postgreSQL, mysql and sqlite)
  * generating text and HTML reports
  * logging

%if_with python3
%package -n python3-module-%oname
Summary: Useful miscellaneous modules used by Logilab projects (Python 3)
Group: Development/Python3
%add_python3_req_skip kerberos mercurial sphinx

%description -n python3-module-%oname
logilab-common is a collection of low-level Python packages and modules,
designed to ease:
  * handling command line options and configuration files
  * writing interactive command line tools
  * manipulation files and character strings
  * interfacing to OmniORB (removed by packager)
  * generating of SQL queries
  * running unit tests
  * manipulating tree structures
  * accessing RDBMS (currently postgreSQL, mysql and sqlite)
  * generating text and HTML reports
  * logging
%endif

%prep
%setup
%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%build
rm corbautils.py
%python_build
%if_with python3
pushd ../python3
rm corbautils.py
cp setup.py setup.py.back
find -type f -name '*.py' -exec sed -i 's|unittest2|unittest|g' -- '{}' +
find -type f -name '*.py' -exec 2to3 -w -n '{}' +
mv -f setup.py.back setup.py
%python3_build
popd
%endif

%install
%if_with python3
pushd ../python3
%python3_install
popd
rm -rf %buildroot%python3_sitelibdir/logilab/common/test
mv %buildroot%_bindir/pytest %buildroot%_bindir/pytest3
%endif

%python_install
install -pD -m644 doc/pytest.1 %buildroot%_man1dir/pytest.1
rm -rf %buildroot%python_sitelibdir/logilab/common/test

%check
touch build/lib/logilab/__init__.py
PYTHONPATH=$(pwd)/build/lib/ \
    $(pwd)/build/scripts-%_python_version/pytest \
    -t test \
    -s test_knownValues_is_standard_module_4
rm -f build/lib/logilab/__init__.py

%files
%_bindir/pytest
%python_sitelibdir/logilab/
%python_sitelibdir/*.egg-info
%_man1dir/*
%doc ChangeLog README

%if_with python3
%files -n python3-module-%oname
%doc ChangeLog README
%_bindir/pytest3
%python3_sitelibdir/logilab/
%python3_sitelibdir/*.egg-info
%endif

%changelog
