%define modulename lxml

%def_with python3

Name: python-module-lxml
Version: 3.1.1
Release: alt1.git20130330

Summary: Powerful and Pythonic XML processing library combining libxml2/libxslt with the ElementTree API.

# http://codespeak.net/lxml/%modulename-%version.tar
# git://github.com/lxml/lxml.git
Source: %name-%version.tar

License: BSD/GPLv2/ZPL/PSF
Group: Development/Python
URL: http://codespeak.net/lxml

Packager: Python Development Team <python@packages.altlinux.org>

BuildPreReq: libxslt-devel python-module-distribute zlib-devel
# see doc/build.txt
BuildPreReq: python-module-Cython >= 0.18

%setup_python_module lxml

%if_with python3
BuildRequires(pre): rpm-build-python3
# see doc/build.txt
BuildPreReq: python3-module-Cython >= 0.18
BuildPreReq: python3-devel python3-module-distribute

%add_python3_req_skip etree
%endif

%description
lxml is a Pythonic, mature binding for the libxml2 and libxslt libraries.  It
provides safe and convenient access to these libraries using the ElementTree
API.

It extends the ElementTree API significantly to offer support for XPath,
RelaxNG, XML Schema, XSLT, C14N and much more.

%if_with python3
%package -n python3-module-%modulename
Summary: XML processing library combining libxml2/libxslt with the ElementTree API (Python 3)
Group: Development/Python3

%description -n python3-module-%modulename
lxml is a Pythonic, mature binding for the libxml2 and libxslt libraries.  It
provides safe and convenient access to these libraries using the ElementTree
API.

It extends the ElementTree API significantly to offer support for XPath,
RelaxNG, XML Schema, XSLT, C14N and much more.

This is module for use with Python 3.
%endif

%package doc
Summary: Documentation for lxml
Group: Development/Documentation
BuildArch: noarch

%description doc
lxml is a Pythonic, mature binding for the libxml2 and libxslt libraries.  It
provides safe and convenient access to these libraries using the ElementTree
API.

It extends the ElementTree API significantly to offer support for XPath,
RelaxNG, XML Schema, XSLT, C14N and much more.

This package contains documentation for lxml.

%prep
%setup
%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%build
# see Makefile
%python_build_debug --with-cython
%if_with python3
pushd ../python3
sed -i 's|/usr/bin/env python.*|/usr/bin/env python3|' \
	update-error-constants.py test.py
sed -i 's|/usr/bin/python|/usr/bin/python3|' \
	doc/rest2latex.py doc/rest2html.py
%python3_build --with-cython
popd
%endif

%install
%python_install
%if_with python3
pushd ../python3
%python3_install
popd
%endif

%check
# see Makefile
CFLAGS="${CFLAGS:-%optflags}" ; export CFLAGS ;
CXXFLAGS="${CXXFLAGS:-%optflags}" ; export CXXFLAGS ;
FFLAGS="${FFLAGS:-%optflags}" ; export FFLAGS ;
cp -l build/lib.linux-*/lxml/*.so src/lxml/
%__python test.py -p -v
PYTHONPATH=src:$PYTHONPATH %__python selftest.py
PYTHONPATH=src:$PYTHONPATH %__python selftest2.py
%if_with python3
pushd ../python3
cp -l build/lib.linux-*/lxml/*.so src/lxml/
%__python3 test.py -p -v
PYTHONPATH=src:$PYTHONPATH %__python3 selftest.py
PYTHONPATH=src:$PYTHONPATH %__python3 selftest2.py
popd
%endif

%files
%python_sitelibdir/*

%if_with python3
%files -n python3-module-%modulename
%python3_sitelibdir/*
%endif

%files doc
%doc doc samples

%changelog
