%define version 2.2.1
%define release alt1
%define modulename markdown

%def_with python3

%setup_python_module %modulename

Name: python-module-%modulename
Version: %version
Release: %release

Summary: Python implementation of Markdown text-to-HTML convertor.
Group: Development/Python
License: %gpl2plus | %bsd
Url: http://pypi.python.org/pypi/Markdown/2.1.1
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# git://github.com/waylan/Python-Markdown.git
Source: %name-%version.tar

BuildArch: noarch
BuildPreReq: rpm-build-licenses

# Automatically added by buildreq on Sun Feb 17 2008
BuildRequires: python-devel
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
%endif

Conflicts: discount

%description
Markdown is a plain text formatting syntax designed to be as readable as
possible while being structured enough to allow conversion to other formats.

This package contains Python implementation of markdown-to-HTML convertor.

%if_with python3
%package -n python3-module-%modulename
Summary: Python 3 implementation of Markdown text-to-HTML convertor
Group: Development/Python

%description -n python3-module-%modulename
Markdown is a plain text formatting syntax designed to be as readable as
possible while being structured enough to allow conversion to other formats.
%endif

%package docs
Summary: Documentation for Markdown
Group: Development/Documentation
BuildArch: noarch

%description docs
Markdown is a plain text formatting syntax designed to be as readable as
possible while being structured enough to allow conversion to other formats.

This package contains documentation for Markdown.

%prep
%setup
%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%build
%python_build
%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%if_with python3
pushd ../python3
%python3_install
popd
mv %buildroot%_bindir/%{modulename}_py \
	%buildroot%_bindir/%{modulename}_py3
%endif

%python_install --optimize=2

ln -s %{modulename}_py %buildroot%_bindir/%modulename

%files
%_bindir/*
%exclude %_bindir/%{modulename}_py3
%python_sitelibdir/*
# disable broken extension
#exclude %python_sitelibdir/%modulename/extensions/imagelinks.py*

%files docs
%doc docs

%if_with python3
%files -n python3-module-%modulename
%_bindir/%{modulename}_py3
%python3_sitelibdir/*
%endif

%changelog
