%define modulename markdown2

%def_with python3

Name: python-module-%modulename
Version: 2.1.0
Release: alt1

Summary: Another implementation of Markdown in Python
Group: Development/Python
License: %gpl2plus | %bsd
Url: http://code.google.com/p/python-markdown2/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# https://github.com/trentm/python-markdown2.git
Source: %modulename-%version.zip

BuildArch: noarch
BuildPreReq: rpm-build-licenses unzip

# Automatically added by buildreq on Sun Feb 17 2008
BuildRequires: python-devel
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
%endif

%description
This project provides a converter written in Python that closely matches
the behaviour of the original Perl-implemented Markdown.pl. There is
another Python markdown.py, but markdown2.py is faster and, to my
knowledge, more correct.

%if_with python3
%package -n python3-module-%modulename
Summary: Another implementation of Markdown in Python 3
Group: Development/Python3

%description -n python3-module-%modulename
This project provides a converter written in Python that closely matches
the behaviour of the original Perl-implemented Markdown.pl. There is
another Python markdown.py, but markdown2.py is faster and, to my
knowledge, more correct.
%endif

%package tests
Summary: Tests for markdown2
Group: Development/Python
BuildArch: noarch
Requires: %name = %version-%release

%description tests
This project provides a converter written in Python that closely matches
the behaviour of the original Perl-implemented Markdown.pl. There is
another Python markdown.py, but markdown2.py is faster and, to my
knowledge, more correct.

This package contains tests for markdown2.

%prep
%setup
%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%build
%python_build
%if_with python3
pushd ../python3
sed -i 's|%_bindir/env python|%_bindir/env python3|' lib/markdown2.py
%python3_build
popd
%endif

%install

%if_with python3
pushd ../python3
%python3_install
popd
%endif
mv %buildroot%_bindir/markdown2 %buildroot%_bindir/py3_markdown2
rm -f %buildroot%python3_sitelibdir/*.pyo

%python_install --optimize=2
rm -f %buildroot%python_sitelibdir/*.pyo

%files
%doc *.txt
%_bindir/markdown2
%python_sitelibdir/*

%files tests
%doc test/*

%if_with python3
%files -n python3-module-%modulename
%doc *.txt
%_bindir/py3_markdown2
%python3_sitelibdir/*
%endif

%changelog
