%define oname ncclient
%def_without python3

Summary: Python library for NETCONF clients
Name: python-module-%oname
Version: 0.4.2
Release: alt0.M70P.1
Url: https://github.com/leopoul/ncclient
Source: %name-%version.tar
Packager: Valentin Rosavitskiy <valintinr@altlinux.org>
License: ASL 2.0
Group: Development/Python

BuildArch: noarch
BuildRequires: python-dev python-module-setupdocs python-module-setuptools

%if_with python3
BuildRequires(pre): rpm-build-python3
BuildPreReq: python3-module-setupdocs python3-module-setuptools
%endif

%description
ncclient is a Python library that facilitates client-side scripting
and application development around the NETCONF protocol. ncclient
was developed by Shikar Bhushan. It is now maintained by Leonidas
Poulopoulos (@leopoul)

%package -n python3-module-%oname
Summary: Python library for NETCONF clients
Group: Development/Python3

%description -n python3-module-%oname
ncclient is a Python library that facilitates client-side scripting
and application development around the NETCONF protocol. ncclient
was developed by Shikar Bhushan. It is now maintained by Leonidas
Poulopoulos (@leopoul)



%prep
%setup

%if_with python3
cp -fR . ../python3
%endif


%build
%add_optflags -fno-strict-aliasing
%python_build

%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%python_build_install --prefix=/usr

%if_with python3
pushd ../python3
%python3_install
popd
%endif


%files
%doc Changelog LICENSE README README.md README.rst requirements.txt
%python_sitelibdir/*

%if_with python3
%files -n python3-module-%oname
%doc Changelog LICENSE README README.md README.rst requirements.txt
%python3_sitelibdir/*
%endif


%changelog
