%define oname nipy

%def_enable docs

Name: python-module-%oname
Version: 0.4.0
Release: alt1.git20130205
Summary: The neuroimaging in python (NIPY) project
License: MIT
Group: Development/Python
Url: http://neuroimaging.scipy.org/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# git://github.com/nipy/nipy.git
Source: %oname-%version.tar.gz

Requires: %oname-data

BuildPreReq: python-devel python-module-nifti python-module-scipy
BuildPreReq: python-module-sympy liblapack-devel python-module-matplotlib
BuildPreReq: /proc gcc-fortran %oname-data libnumpy-devel sympy
BuildPreReq: dvipng libniftilib-devel
BuildPreReq: python-module-nibabel python-module-Cython
BuildPreReq: python-module-sphinx-devel python-module-Pygments
BuildPreReq: graphviz ghostscript-utils
%setup_python_module %oname

%description
The neuroimaging in python (NIPY) project is an environment for the
analysis of structural and functional neuroimaging data. It currently
has a full system for general linear modeling of functional magnetic
resonance imaging (fMRI).

%package examples
Summary: Examples for neuroimaging in python (NIPY) project
Group: Development/Documentation
Requires: %name = %version-%release

%description examples
The neuroimaging in python (NIPY) project is an environment for the
analysis of structural and functional neuroimaging data. It currently
has a full system for general linear modeling of functional magnetic
resonance imaging (fMRI).

This package contains examples for NIPY.

%package tests
Summary: Tests for neuroimaging in python (NIPY) project
Group: Development/Python
Requires: %name = %version-%release

%description tests
The neuroimaging in python (NIPY) project is an environment for the
analysis of structural and functional neuroimaging data. It currently
has a full system for general linear modeling of functional magnetic
resonance imaging (fMRI).

This package contains tests for NIPY.

%if_enabled docs

%package docs
Summary: Documentation for neuroimaging in python (NIPY) project
Group: Development/Documentation
BuildArch: noarch

%description docs
The neuroimaging in python (NIPY) project is an environment for the
analysis of structural and functional neuroimaging data. It currently
has a full system for general linear modeling of functional magnetic
resonance imaging (fMRI).

This package contains documentation for NIPY.

%package pickles
Summary: Pickles for neuroimaging in python (NIPY) project
Group: Development/Python

%description pickles
The neuroimaging in python (NIPY) project is an environment for the
analysis of structural and functional neuroimaging data. It currently
has a full system for general linear modeling of functional magnetic
resonance imaging (fMRI).

This package contains pickles for NIPY.

%endif

%prep
%setup

%if_enabled docs
sed -i 's|@PYVER@|%_python_version|g' doc/Makefile
%prepare_sphinx .
%endif

rm -f doc/labs/image_registration.rst

%build
%python_build_debug

%install
%python_install
export PYTHONPATH=%buildroot%python_sitelibdir

mkdir -p ~/.matplotlib
cp %python_sitelibdir/matplotlib/mpl-data/matplotlibrc ~/.matplotlib/
sed -i 's|^\(backend\).*|\1 : PDF|' ~/.matplotlib/matplotlibrc

%if_enabled docs
%make -C doc pickle
%make -C doc html
#make -C doc pdf
%endif

install fff2.py %buildroot%python_sitelibdir
cp -fR examples %buildroot%python_sitelibdir/%oname/

%if_enabled docs
#mkdir -p doc/pdf
#for i in $(find doc -name '*.pdf'); do
#	cp -f $i doc/pdf/
#done

cp -fR doc/build/pickle %buildroot%python_sitelibdir/%oname/
%endif

%files
%doc AUTHOR Changelog LICENSE README* THANKS
%_bindir/*
%python_sitelibdir/*
%if_enabled docs
%exclude %python_sitelibdir/%oname/pickle
%endif
%exclude %python_sitelibdir/*/examples
%exclude %python_sitelibdir/*/testing
%exclude %python_sitelibdir/*/*/tests
%exclude %python_sitelibdir/*/*/*/tests
%exclude %python_sitelibdir/*/*/*/testing
%exclude %python_sitelibdir/*/*/*/*/tests
#exclude %python_sitelibdir/*/*/*/*/*/tests
%exclude %python_sitelibdir/*/*/*/test

%if_enabled docs
%files docs
%doc doc/build/html/*
#doc doc/pdf

%files pickles
%dir %python_sitelibdir/%oname
%python_sitelibdir/%oname/pickle
%endif

%files examples
%python_sitelibdir/*/examples

%files tests
%python_sitelibdir/*/*/*/test
%python_sitelibdir/*/testing
%python_sitelibdir/*/*/tests
%python_sitelibdir/*/*/*/tests
%python_sitelibdir/*/*/*/testing
%python_sitelibdir/*/*/*/*/tests
#python_sitelibdir/*/*/*/*/*/tests

%changelog
