%define oname nose

%def_with python3

Name: python-module-%oname
Epoch: 1
Version: 1.2.1
Release: alt1.git20130317

Summary: A unittest-based testing framework for python that makes writing and running tests easier

Group: Development/Python
License: LGPL
#Url: http://code.google.com/p/python-nose/
#Url: https://github.com/nose-devs/nose
Url: http://www.somethingaboutorange.com/mrl/projects/nose/

BuildArch: noarch

%setup_python_module %oname

Source: %name-%version.tar
Patch1: nose-1.1.2-alt-syntax-error-patch_py.patch

BuildRequires: python-module-setuptools python-module-coverage

%description
nose provides an alternate test discovery and running process for
unittest, one that is intended to mimic the behavior of py.test as much
as is reasonably possible without resorting to too much magic.

%if_with python3
%package -n python3-module-%oname
Summary: A unittest-based testing framework for python3 that makes writing and running tests easier
Group: Development/Python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-distribute python3-module-coverage

%description -n python3-module-%oname
nose provides an alternate test discovery and running process for
unittest, one that is intended to mimic the behavior of py.test as much
as is reasonably possible without resorting to too much magic.
%endif

%prep
%setup
%patch1 -p2

sed -i "s|man/man1|share/man/man1|g" setup.py
%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%build
%python_build
%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%python_install
%if_with python3
pushd ../python3
%python3_install
popd
%endif

rm -f %buildroot%_bindir/nosetests
ln -s nosetests-%__python_version %buildroot%_bindir/nosetests
%if_with python3
ln -s nosetests-%__python3_version %buildroot%_bindir/nosetests3
%endif

%check
./selftest.py
%if_with python3
pushd ../python3
python3 setup.py build_tests
python3 ./selftest.py
popd
%endif

%files
%doc AUTHORS CHANGELOG NEWS README.txt examples/
%_bindir/nosetests
%_bindir/nosetests-%__python_version
%python_sitelibdir/%oname/
%python_sitelibdir/*.egg-info
%_man1dir/*

%if_with python3
%files -n python3-module-%oname
%_bindir/nosetests3
%_bindir/nosetests-%__python3_version
%python3_sitelibdir/%oname/
%python3_sitelibdir/*.egg-info
%endif

%changelog
