%global sname oslo.config

Name:       python-module-oslo-config
Version:    1.2.1
Release:    alt1
Summary:    OpenStack common configuration library

Group:      Development/Python
License:    ASL 2.0
URL:        https://launchpad.net/oslo
Source0:    %{name}-%{version}.tar
#
# patches_base=1.2.1
#
Patch0001: 0001-add-usr-share-project-dist.conf-to-the-default-confi.patch
Patch0002: 0002-Revert-Use-oslo.sphinx-and-remove-local-copy-of-doc-.patch
Patch0003: 0003-oslo-config-namespace_packages-remove.patch

BuildArch:  noarch
Requires:   python-module-setuptools
Requires:   python-module-argparse
Requires:   python-module-six

BuildRequires: python-devel
BuildRequires: python-module-setuptools
BuildRequires: python-module-pbr
BuildRequires: python-module-d2to1

%description
The Oslo project intends to produce a python library containing
infrastructure code shared by OpenStack projects. The APIs provided
by the project should be high quality, stable, consistent and generally
useful.

The oslo-config library is a command line and configuration file
parsing library from the Oslo project.

%package doc
Summary:    Documentation for OpenStack common configuration library
Group:      Documentation

BuildRequires: python-module-sphinx

%description doc
Documentation for the oslo-config library.

%prep
%setup

%patch0001 -p1
%patch0002 -p1
%patch0003 -p1

# Remove bundled egg-info
rm -rf %{sname}.egg-info
# let RPM handle deps
sed -i '/setup_requires/d; /install_requires/d; /dependency_links/d' setup.py

%build
%python_build

%install
%python_install

# Delete tests
rm -fr %{buildroot}%{python_sitelibdir}/tests

export PYTHONPATH="$( pwd ):$PYTHONPATH"
pushd doc
sphinx-build -b html -d build/doctrees   source build/html
popd
# Fix hidden-file-or-dir warnings
rm -fr doc/build/html/.buildinfo

%check

%files
%doc README.rst
%{python_sitelibdir}/oslo
%{python_sitelibdir}/*.egg-info
#%%{python_sitelibdir}/*-nspkg.pth

%files doc
%doc LICENSE doc/build/html

%changelog
