%define pypi_name pelican

Name: python-module-%pypi_name
Version: 3.5.0
Release: alt0.M70P.1
Summary: A tool to generate a static blog from reStructuredText or Markdown input files
Group: Development/Python

License: AGPLv3
Url: http://getpelican.com/
# https://github.com/getpelican/pelican/archive/%version.tar.gz#/%pypi_name-%version.tar.gz
Source: %pypi_name-%version.tar

BuildArch: noarch

BuildRequires: python-devel python-module-blinker python-module-dateutil python-module-sphinx python-module-pytz python-module-unidecode python-module-mock

# for django.utils.feedgenerator
BuildPreReq: python-module-django

%add_findreq_skiplist %python_sitelibdir/%pypi_name/tools/templates/*

%py_requires unidecode

%description
Pelican is a static site generator, written in Python_.

* Write your weblog entries directly with your editor of choice (vim!)
  in reStructuredText_ or Markdown_
* Includes a simple CLI tool to ...

%prep
%setup -n %pypi_name-%version
# Remove bundled egg-info
rm -rf %pypi_name.egg-info

# remove bagpath #!/usr/bin/env from files
sed -i '1d' pelican/tools/pelican_import.py
sed -i '1d' pelican/tools/pelican_quickstart.py
sed -i '1d' pelican/tools/pelican_themes.py
sed -i '1d' pelican/tools/templates/pelicanconf.py.in

# substitute feedgenerator with it's original django
sed -i 's|feedgenerator|django.utils.feedgenerator|' pelican/writers.py
sed -i "s|'feedgenerator >= 1.6', ||" setup.py

%build
%python_build

# build docs
sphinx-build docs html

# remove leftovers from sphinxbuild
rm html/_downloads/theme-basic.zip html/_static/theme-basic.zip
rm -rf html/.doctrees html/.buildinfo

%install
%python_install

%check
# disable tests for now. they are a bit unstable due comparing
# html attributes via diff. Failed several times, when attributes
# were ordered differently!
LC_ALL=en_US.UTF-8 python -m unittest discover ||:

%files
%doc html README.rst LICENSE
%_bindir/pelican
%_bindir/pelican-import
%_bindir/pelican-quickstart
%_bindir/pelican-themes
%python_sitelibdir/%pypi_name
%python_sitelibdir/%pypi_name-*-py?.?.egg-info

%changelog
